% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{sequential_pal}
\alias{sequential_pal}
\title{Sequential palette}
\usage{
sequential_pal(n)
}
\arguments{
\item{n}{The number of colors in the palette. The maximum is nine
currently.}
}
\value{
A character vector of RGB color codes.
}
\description{
This is the \sQuote{OrRd} palette from \url{https://colorbrewer2.org}.
It has at most nine colors.
}
\details{
Use this palette, if vertex colors mark some ordinal quantity, e.g. some
centrality measure, or some ordinal vertex covariate, like the age of
people, or their seniority level.
}
\examples{
\dontrun{
library(igraphdata)
data(karate)
karate <- karate \%>\%
  add_layout_(with_kk()) \%>\%
  set_vertex_attr("size", value = 10)

V(karate)$color <- scales::dscale(degree(karate) \%>\% cut(5), sequential_pal)
plot(karate)
}
}
\seealso{
Other palettes: 
\code{\link{categorical_pal}()},
\code{\link{diverging_pal}()},
\code{\link{r_pal}()}
}
\concept{palettes}
