% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisBubbleChart.R
\name{gvisBubbleChart}
\alias{gvisBubbleChart}
\title{Google Bubble Chart with R
\Sexpr{googleChartName <- "bubblechart"}
\Sexpr{gvisChartName <- "gvisBubbleChart"}}
\usage{
gvisBubbleChart(
  data,
  idvar = "",
  xvar = "",
  yvar = "",
  colorvar = "",
  sizevar = "",
  options = list(),
  chartid
)
}
\arguments{
\item{data}{a \code{\link{data.frame}} to be displayed as a bubble chart.
The data has to have at least three columns for \code{idvar, xvar}, and
\code{yvar}.}

\item{idvar}{column name of \code{data} with the bubble}

\item{xvar}{column name of a numerical vector in \code{data} to be plotted
on the x-axis.}

\item{yvar}{column name of a numerical vector in \code{data} to be plotted
on the y-axis.}

\item{colorvar}{column name of data that identifies bubbles in the same
series. Use the same value to identify all bubbles that belong to the same
series; bubbles in the same series will be assigned the same color. Series
can be configured using the \code{series} option.}

\item{sizevar}{values in this column are mapped to actual pixel values using
the \code{sizeAxis} option.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}.}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisBubbleChart function reads a data.frame and creates text output
referring to the Google Visualisation API, which can be included into a web
page, or as a stand-alone page.
}
\details{
A bubble chart is used to visualize a data set with 2 to 4 dimensions. The
first two dimensions are visualized as coordinates, the 3rd as color and the
4th as size.

The bubble chart is rendered within the browser using SVG or VML and
displays tips when hovering over points.
}
\examples{


bubble1 <- gvisBubbleChart(Fruits, idvar="Fruit", xvar="Sales", yvar="Expenses")
plot(bubble1)

## Set color and size
bubble2 <- gvisBubbleChart(Fruits, idvar="Fruit", xvar="Sales", yvar="Expenses",
                          colorvar="Location", sizevar="Profit",
                          options=list(hAxis='{minValue:75, maxValue:125}'))

plot(bubble2)

## Use year to color the bubbles
bubble3 <- gvisBubbleChart(Fruits, idvar="Fruit", xvar="Sales", yvar="Expenses",
                           colorvar="Year", sizevar="Profit",
                           options=list(hAxis='{minValue:75, maxValue:125}'))
plot(bubble3)

## Gradient colour example
bubble4 <- gvisBubbleChart(Fruits, idvar="Fruit", xvar="Sales", yvar="Expenses",
                          sizevar="Profit",
                          options=list(hAxis='{minValue:75,  maxValue:125}', 
                                  colorAxis="{colors: ['lightblue', 'blue']}"))
plot(bubble4)

\dontrun{
## Moving bubble chart over time, aka motion chart

M <- gvisMotionChart(Fruits, Fruit, Year)
plot(M)
}




}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{gvisMotionChart}} for a moving bubble chart
over time, and \code{\link{print.gvis}}, \code{\link{plot.gvis}} for
printing and plotting methods.
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\keyword{iplot}
