% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit.coxnet.R
\name{survfit.coxnet}
\alias{survfit.coxnet}
\title{Compute a survival curve from a coxnet object}
\usage{
\method{survfit}{coxnet}(formula, s = NULL, ...)
}
\arguments{
\item{formula}{A class \code{coxnet} object.}

\item{s}{Value(s) of the penalty parameter lambda at which the survival
curve is required. Default is the entire sequence used to create the model.
However, it is recommended that \code{survfit.coxnet} is called for
a single penalty parameter.}

\item{...}{This is the mechanism for passing additional arguments like
(i) x= and y= for the x and y used to fit the model,
(ii) weights= and offset= when the model was fit with these options,
(iii) arguments for new data (newx, newoffset, newstrata), and
(iv) arguments to be passed to survfit.coxph().}
}
\value{
If \code{s} is a single value, an object of class "survfitcox"
and "survfit" containing one or more survival curves. Otherwise, a list
of such objects, one element for each value in \code{s}.
Methods defined for survfit objects are print, summary and plot.
}
\description{
Computes the predicted survivor function for a Cox proportional hazards
model with elastic net penalty.
}
\details{
To be consistent with other functions in \code{glmnet}, if \code{s}
is not specified, survival curves are returned for the entire lambda
sequence. This is not recommended usage: it is best to call
\code{survfit.coxnet} with a single value of the penalty parameter
for the \code{s} option.
}
\examples{
set.seed(2)
nobs <- 100; nvars <- 15
xvec <- rnorm(nobs * nvars)
xvec[sample.int(nobs * nvars, size = 0.4 * nobs * nvars)] <- 0
x <- matrix(xvec, nrow = nobs)
beta <- rnorm(nvars / 3)
fx <- x[, seq(nvars / 3)] \%*\% beta / 3
ty <- rexp(nobs, exp(fx))
tcens <- rbinom(n = nobs, prob = 0.3, size = 1)
y <- survival::Surv(ty, tcens)
fit1 <- glmnet(x, y, family = "cox")

# survfit object for Cox model where lambda = 0.1
sf1 <- survival::survfit(fit1, s = 0.1, x = x, y = y)
plot(sf1)

# example with new data
sf2 <- survival::survfit(fit1, s = 0.1, x = x, y = y, newx = x[1:3, ])
plot(sf2)

# example with strata
y2 <- stratifySurv(y, rep(1:2, length.out = nobs))
fit2 <- glmnet(x, y2, family = "cox")
sf3 <- survival::survfit(fit2, s = 0.1, x = x, y = y2)
sf4 <- survival::survfit(fit2, s = 0.1, x = x, y = y2,
               newx = x[1:3, ], newstrata = c(1, 1, 1))

}
