% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/css.R
\name{generate_css}
\alias{generate_css}
\title{Generate CSS to import fonts}
\usage{
generate_css(
  id,
  variants = NULL,
  subsets = NULL,
  output = NULL,
  font_dir = "../fonts/",
  prefer_local_source = TRUE,
  browser_support = c("best", "modern"),
  ...
)
}
\arguments{
\item{id}{Id of the font, correspond to column \code{id} from \code{\link{get_all_fonts}}.}

\item{variants}{Variant of font to use.}

\item{subsets}{Subsets to use.}

\item{output}{Specifies path to output file for CSS generated.}

\item{font_dir}{Fonts directory relative to \code{ouput}.}

\item{prefer_local_source}{Generate CSS font-face rules in which user installed fonts are
preferred. Use \code{FALSE} if you want to force the use of the downloaded font.}

\item{browser_support}{Browser to support, choose \code{"best"} to support
old browser or \code{"modern"} for only recent ones.}

\item{...}{Arguments passed to \code{crul::HttpClient$new}.}
}
\value{
a character string with CSS code (invisibly).
}
\description{
Generate CSS to import fonts
}
\examples{
if (interactive()) {

# Generate CSS code to use Roboto font
cat(generate_css("roboto", "regular"))

}
}
