% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_OR_to_RR.R
\name{oddsratio_to_riskratio}
\alias{oddsratio_to_riskratio}
\alias{riskratio_to_oddsratio}
\title{Convert Between Odds Ratios and Risk Ratios}
\usage{
oddsratio_to_riskratio(OR, p0, log = FALSE, verbose = TRUE, ...)

riskratio_to_oddsratio(RR, p0, log = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{OR, RR}{Risk ratio of \code{p1/p0} or Odds ratio of \code{odds(p1)/odds(p0)},
possibly log-ed. \code{OR} can also be a logistic regression model.}

\item{p0}{Baseline risk}

\item{log}{Take in or output the log of the ratio (such as in logistic models).}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to and from other methods.}
}
\value{
Converted index, or if \code{OR} is a logistic regression model, a
parameter table with the converted indices.
}
\description{
Convert Between Odds Ratios and Risk Ratios
}
\examples{
p0 <- 0.4
p1 <- 0.7

(OR <- probs_to_odds(p1) / probs_to_odds(p0))
(RR <- p1 / p0)

riskratio_to_oddsratio(RR, p0 = p0)
oddsratio_to_riskratio(OR, p0 = p0)

m <- glm(am ~ factor(cyl),
  data = mtcars,
  family = binomial()
)
oddsratio_to_riskratio(m, verbose = FALSE) # RR is relative to the intercept if p0 not provided
}
\references{
Grant, R. L. (2014). Converting an odds ratio to a range of plausible
relative risks for better communication of research findings. Bmj, 348,
f7450.
}
\seealso{
\code{\link[=oddsratio]{oddsratio()}} and \code{\link[=riskratio]{riskratio()}}

Other convert between effect sizes: 
\code{\link{d_to_r}()},
\code{\link{diff_to_cles}},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()}
}
\concept{convert between effect sizes}
