% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-roundtrip.R
\docType{data}
\name{spec_result_roundtrip}
\alias{spec_result_roundtrip}
\title{spec_result_roundtrip}
\description{
spec_result_roundtrip
}
\section{Specification}{

The column types of the returned data frame depend on the data returned:
\itemize{
\item \link{integer} (or coercible to an integer) for integer values between -2^31 and 2^31 - 1,
with \link{NA} for SQL \code{NULL} values
\item \link{numeric} for numbers with a fractional component,
with NA for SQL \code{NULL} values
\item \link{logical} for Boolean values (some backends may return an integer);
with NA for SQL \code{NULL} values
\item \link{character} for text,
with NA for SQL \code{NULL} values
\item lists of \link{raw} for blobs
with \link{NULL} entries for SQL NULL values
\item coercible using \code{\link[=as.Date]{as.Date()}} for dates,
with NA for SQL \code{NULL} values
(also applies to the return value of the SQL function \code{current_date})
\item coercible using \code{\link[hms:hms]{hms::as_hms()}} for times,
with NA for SQL \code{NULL} values
(also applies to the return value of the SQL function \code{current_time})
\item coercible using \code{\link[=as.POSIXct]{as.POSIXct()}} for timestamps,
with NA for SQL \code{NULL} values
(also applies to the return value of the SQL function \code{current_timestamp})
}

If dates and timestamps are supported by the backend, the following R types are
used:
\itemize{
\item \link[lubridate:date_utils]{lubridate::Date} for dates
(also applies to the return value of the SQL function \code{current_date})
\item \link[lubridate:posix_utils]{lubridate::POSIXct} for timestamps
(also applies to the return value of the SQL function \code{current_timestamp})
}

R has no built-in type with lossless support for the full range of 64-bit
or larger integers. If 64-bit integers are returned from a query,
the following rules apply:
\itemize{
\item Values are returned in a container with support for the full range of
valid 64-bit values (such as the \code{integer64} class of the \pkg{bit64}
package)
\item Coercion to numeric always returns a number that is as close as possible
to the true value
\item Loss of precision when converting to numeric gives a warning
\item Conversion to character always returns a lossless decimal representation
of the data
}
}

\seealso{
Other result specifications: 
\code{\link{spec_result_clear_result}},
\code{\link{spec_result_create_table_with_data_type}},
\code{\link{spec_result_execute}},
\code{\link{spec_result_fetch}},
\code{\link{spec_result_get_query}},
\code{\link{spec_result_send_query}},
\code{\link{spec_result_send_statement}}
}
\concept{result specifications}
