% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{glance.basis}
\alias{glance.basis}
\title{Glance at a basis object}
\usage{
\method{glance}{basis}(x, include_diagnostics = FALSE, ...)
}
\arguments{
\item{x}{a basis object}

\item{include_diagnostics}{a logical value indicating whether to include
columns for diagnostic tests. Default FALSE.}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with the following
columns:
\itemize{
\item \code{p} the the content of the tolerance bound. Normally 0.90 or 0.99
\item \code{conf} the confidence level. Normally 0.95
\item \code{distribution} a string representing the distribution assumed
when calculating the basis value
\item \code{modcv} a logical value indicating whether the modified
CV approach was used. Only applicable to pooling methods.
\item \code{n} the sample size
\item \code{r} the number of groups used in the calculation. This will
be \code{NA} for single-point basis values
\item \code{basis} the basis value
}
}
\description{
Glance accepts an object of type basis and returns a
\code{\link[tibble:tibble]{tibble::tibble()}} with
one row of summaries for each basis value.

Glance does not do any calculations: it just gathers the results in a
tibble.
}
\details{
For the pooled basis methods (\code{basis_pooled_cv} and
\code{basis_pooled_sd}), the \code{\link[tibble:tibble]{tibble::tibble()}}
returned by \code{glance} will have one row for each group included in
the pooling. For all other basis methods, the resulting \code{tibble}
will have a single row.

If \code{include_diagnostics=TRUE}, there will be additional columns
corresponding with the diagnostic tests performed. These column(s) will
be of type character and will contain a "P" if the diagnostic test
passed, a "F" if the diagnostic test failed, an "O" if the diagnostic
test was overridden or \code{NA} if the test was not run (typically
because an optional argument was not passed to the function that
computed the basis value).
}
\examples{
set.seed(10)
x <- rnorm(20, 100, 5)
b <- basis_normal(x = x)
glance(b)

## # A tibble: 1 x 7
##       p  conf distribution modcv     n r     basis
##   <dbl> <dbl> <chr>        <lgl> <int> <lgl> <dbl>
## 1   0.9  0.95 Normal       FALSE    20 NA     92.0


glance(b, include_diagnostics = TRUE)

## # A tibble: 1 x 11
##        p  conf distribution modcv     n r     basis outliers_within…
##    <dbl> <dbl> <chr>        <lgl> <int> <lgl> <dbl> <chr>
##  1   0.9  0.95 Normal       FALSE    20 NA     92.0 NA
## # … with 3 more variables: between_batch_variability <chr>,
## #   outliers <chr>, anderson_darling_normal <chr>

}
\seealso{
\code{\link[=basis]{basis()}}
}
