% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-function.R
\name{chk_function}
\alias{chk_function}
\alias{vld_function}
\title{Check Function}
\usage{
chk_function(x, formals = NULL, x_name = NULL)

vld_function(x, formals = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{formals}{A count of the number of formal arguments.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if is a function using

\code{is.function(x) && (is.null(formals) || length(formals(x)) == formals)}
}
\section{Functions}{
\itemize{
\item \code{vld_function()}: Validate Function

}}
\examples{
# chk_function
chk_function(mean)
try(chk_function(1))
# vld_function
vld_function(mean)
vld_function(function(x) x)
vld_function(1)
vld_function(list(1))
}
\seealso{
\code{\link[=is.function]{is.function()}} \code{\link[=formals]{formals()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other missing_checkers: 
\code{\link{chk_missing}()},
\code{\link{chk_not_missing}()}
}
\concept{ellpisis_checkers}
\concept{function_checkers}
\concept{missing_checkers}
