% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme4_tidiers.R
\name{lme4_tidiers}
\alias{lme4_tidiers}
\alias{glance.allFit}
\alias{tidy.allFit}
\alias{tidy.merMod}
\alias{tidy.rlmerMod}
\alias{augment.merMod}
\alias{glance.merMod}
\title{Tidying methods for mixed effects models}
\usage{
\method{tidy}{merMod}(
  x,
  effects = c("ran_pars", "fixed"),
  scales = NULL,
  exponentiate = FALSE,
  exponentiate_ran_coefs = FALSE,
  ran_prefix = NULL,
  conf.int = FALSE,
  conf.level = 0.95,
  conf.method = "Wald",
  ddf.method = NULL,
  profile = NULL,
  debug = FALSE,
  ...
)

\method{tidy}{rlmerMod}(
  x,
  effects = c("ran_pars", "fixed"),
  scales = NULL,
  exponentiate = FALSE,
  exponentiate_ran_coefs = FALSE,
  ran_prefix = NULL,
  conf.int = FALSE,
  conf.level = 0.95,
  conf.method = "Wald",
  ddf.method = NULL,
  profile = NULL,
  debug = FALSE,
  ...
)

\method{augment}{merMod}(x, data = stats::model.frame(x), newdata, ...)

\method{glance}{merMod}(x, ...)
}
\arguments{
\item{x}{An object of class \code{merMod}, such as those from \code{lmer},
\code{glmer}, or \code{nlmer}}

\item{effects}{A character vector including one or more of "fixed" (fixed-effect parameters); "ran_pars" (variances and covariances or standard deviations and correlations of random effect terms); "ran_vals" (conditional modes/BLUPs/latent variable estimates); or "ran_coefs" (predicted parameter values for each group, as returned by \code{\link[lme4]{coef.merMod}})}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"vcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects.}

\item{exponentiate}{whether to exponentiate the fixed-effect coefficient estimates and confidence intervals (common for logistic regression); if \code{TRUE}, also scales the standard errors by the exponentiated coefficient, transforming them to the new scale}

\item{exponentiate_ran_coefs}{whether to exponentiate the predicted paramater values for each group}

\item{ran_prefix}{a length-2 character vector specifying the strings to use as prefixes for self- (variance/standard deviation) and cross- (covariance/correlation) random effects terms}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{conf.method}{method for computing confidence intervals (see \code{lme4::confint.merMod})}

\item{ddf.method}{the method for computing the degrees of freedom and t-statistics (only applicable when using the \pkg{lmerTest} package: see \code{\link[lmerTest]{summary.lmerModLmerTest}}}

\item{profile}{pre-computed profile object, for speed when using \code{conf.method="profile"}}

\item{debug}{print debugging output?}

\item{...}{Additional arguments (passed to \code{confint.merMod} for \code{tidy}; \code{augment_columns} for \code{augment}; ignored for \code{glance})}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
with groups depending on the \code{effects} parameter.
It contains the columns
  \item{group}{the group within which the random effect is being estimated: \code{"fixed"} for fixed effects}
  \item{level}{level within group (\code{NA} except for modes)}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}
  \item{std.error}{standard error}
  \item{statistic}{t- or Z-statistic (\code{NA} for modes)}
  \item{p.value}{P-value computed from t-statistic (may be missing/NA)}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

Also added for "merMod" objects, but not for "mer" objects,
are values from the response object within the model (of type
\code{lmResp}, \code{glmResp}, \code{nlsResp}, etc). These include \code{".mu",
".offset", ".sqrtXwt", ".sqrtrwt", ".eta"}.

\code{glance} returns one row with the columns
  \item{nobs}{the number of observations}
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
}
\description{
These methods tidy the coefficients of \code{lme4::lmer} and \code{lme4::glmer}
models (i.e., \code{merMod} objects). Methods are also provided for \code{allFit}
objects.
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

if (require("lme4")) {
    ## original model
    \dontrun{
        lmm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
    }
    ## load stored object
    load(system.file("extdata", "lme4_example.rda", package="broom.mixed"))
    (tt <- tidy(lmm1))
    tidy(lmm1, effects = "fixed")
    tidy(lmm1, effects = "fixed", conf.int=TRUE)
    tidy(lmm1, effects = "fixed", conf.int=TRUE, conf.method="profile")
    ## lmm1_prof <- profile(lmm1) # generated by extdata/runexamples
    tidy(lmm1, conf.int=TRUE, conf.method="profile", profile=lmm1_prof)
    ## conditional modes (group-level deviations from population-level estimate)
    tidy(lmm1, effects = "ran_vals", conf.int=TRUE)
    ## coefficients (group-level estimates)
    (rcoef1 <- tidy(lmm1, effects = "ran_coefs"))
    if (require(tidyr) && require(dplyr)) {
       ## reconstitute standard coefficient-by-level table
       spread(rcoef1,key=term,value=estimate)
       ## split ran_pars into type + term; sort fixed/sd/cor
       (tt \%>\% separate(term,c("type","term"),sep="__",fill="left")
           \%>\% arrange(!is.na(type),desc(type)))
    }
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    glmm1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
                  data = cbpp, family = binomial)
    tidy(glmm1)
    tidy(glmm1,exponentiate=TRUE)
    tidy(glmm1, effects = "fixed")
    ## suppress warning about influence.merMod
    head(suppressWarnings(augment(glmm1, cbpp)))
    glance(glmm1)

    startvec <- c(Asym = 200, xmid = 725, scal = 350)
    nm1 <- nlmer(circumference ~ SSlogis(age, Asym, xmid, scal) ~ Asym|Tree,
                  Orange, start = startvec)
    ## suppress warnings about var-cov matrix ...
    op <- options(warn=-1)
    tidy(nm1)
    tidy(nm1, effects = "fixed")
    options(op)
    head(augment(nm1, Orange))
    glance(nm1)
    detach("package:lme4")
}
if (require("lmerTest")) {
   lmm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
   tidy(lmm1)
   glance(lmm1)
   detach("package:lmerTest")  # clean up
}
}
\seealso{
\link{na.action}
}
