% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_rev}
\alias{merge_rev}
\alias{merge_match}
\alias{merge_in}
\alias{merge_notin}
\alias{merge_duplicated}
\alias{merge_anyDuplicated}
\alias{merge_sumDuplicated}
\alias{merge_unique}
\alias{merge_union}
\alias{merge_setdiff}
\alias{merge_symdiff}
\alias{merge_intersect}
\alias{merge_setequal}
\alias{merge_rangein}
\alias{merge_rangenotin}
\alias{merge_rangesect}
\alias{merge_rangediff}
\alias{merge_first}
\alias{merge_last}
\alias{merge_firstin}
\alias{merge_lastin}
\alias{merge_firstnotin}
\alias{merge_lastnotin}
\title{Fast functions for sorted sets of integer}
\usage{
merge_rev(x)

merge_match(x, y, revx = FALSE, revy = FALSE, nomatch = NA_integer_)

merge_in(x, y, revx = FALSE, revy = FALSE)

merge_notin(x, y, revx = FALSE, revy = FALSE)

merge_duplicated(x, revx = FALSE)

merge_anyDuplicated(x, revx = FALSE)

merge_sumDuplicated(x, revx = FALSE)

merge_unique(x, revx = FALSE)

merge_union(
  x,
  y,
  revx = FALSE,
  revy = FALSE,
  method = c("unique", "exact", "all")
)

merge_setdiff(x, y, revx = FALSE, revy = FALSE, method = c("unique", "exact"))

merge_symdiff(x, y, revx = FALSE, revy = FALSE, method = c("unique", "exact"))

merge_intersect(
  x,
  y,
  revx = FALSE,
  revy = FALSE,
  method = c("unique", "exact")
)

merge_setequal(x, y, revx = FALSE, revy = FALSE, method = c("unique", "exact"))

merge_rangein(rx, y, revx = FALSE, revy = FALSE)

merge_rangenotin(rx, y, revx = FALSE, revy = FALSE)

merge_rangesect(rx, y, revx = FALSE, revy = FALSE)

merge_rangediff(rx, y, revx = FALSE, revy = FALSE)

merge_first(x, revx = FALSE)

merge_last(x, revx = FALSE)

merge_firstin(rx, y, revx = FALSE, revy = FALSE)

merge_lastin(rx, y, revx = FALSE, revy = FALSE)

merge_firstnotin(rx, y, revx = FALSE, revy = FALSE)

merge_lastnotin(rx, y, revx = FALSE, revy = FALSE)
}
\arguments{
\item{x}{a sorted set}

\item{y}{a sorted set}

\item{revx}{default \code{FALSE}, set to \code{TRUE} to reverse scan parameter 'x'}

\item{revy}{default \code{FALSE}, set to \code{TRUE} to reverse scan parameter 'y'}

\item{nomatch}{integer value returned for non-matched elements, see \code{\link{match}}}

\item{method}{one of "unique", "exact" (or "all") which governs how to treat ties, see the function descriptions}

\item{rx}{range of integers given as \code{\link{ri}} or as a two-element \code{\link{integer}}}
}
\value{
\code{merge_rev(x)} returns \code{-\link{rev}(x)} for \code{\link{integer}} and \code{\link{double}} and \code{!\link{rev}(x)} for \code{\link{logical}}
}
\description{
The \code{merge_} functions allow unary and binary operations 
on (ascending) sorted vectors of \code{link{integer}}. 
\code{merge_rev(x)} will do in one scan what costs two scans in \code{-\link{rev}(x)}, see also \code{\link{reverse_vector}(x)}.
Many of these \code{merge_} can optionally scan their input in reverse order (and switch the sign), 
which again saves extra scans for calling \code{merge_rev(x)} first.
}
\details{
These are low-level functions and hence do not check whether the set is actually sorted. 
Note that the `merge_*` and `merge_range*` functions have no special treatment for `NA`. 
If vectors with `NA` are sorted ith `NA` in the first positions (`na.last=FALSE`) and arguments `revx=` or `revy=` have not been used, 
then `NAs` are treated like ordinary integers. 
`NA` sorted elsewhere or using `revx=` or `revy=` can cause unexpected results 
(note for example that `revx=` switches the sign on all integers but `NAs`). 
\cr
\cr
The *binary* `merge_*` functions have a `method="exact"` 
which in both sets treats consecutive occurrences of the same value as if they were different values,
more precisely they are handled as if the identity of ties were tuples of \code{ties, rank(ties)}. 
\code{method="exact"} delivers unique output if the input is unique, and in this case works faster than \code{method="unique"}.
}
\section{Functions}{
\itemize{
\item \code{merge_match}: returns integer positions of sorted set x in sorted set y, see \code{\link{match}(x, y, ...)}

\item \code{merge_in}: returns logical existence of sorted set x in sorted set y, see \code{x \link{\%in\%} y}

\item \code{merge_notin}: returns logical in-existence of sorted set x in sorted set y, see \code{!(x \link{\%in\%} y)}

\item \code{merge_duplicated}: returns the duplicated status of a sorted set x, see \code{\link{duplicated}}

\item \code{merge_anyDuplicated}: returns the anyDuplicated status of a sorted set x, see \code{\link{anyDuplicated}}

\item \code{merge_sumDuplicated}: returns the sumDuplicated status of a sorted set x, see \code{\link{bit_sumDuplicated}}

\item \code{merge_unique}: returns unique elements of sorted set x, see \code{\link{unique}}

\item \code{merge_union}: returns union of two sorted sets.
Default \code{method='unique'} returns a unique sorted set, see \code{\link{union}}; 
\code{method='exact'} returns a sorted set with the maximum number of ties in either input set;
\code{method='all'} returns a sorted set with the sum of ties in both input sets.

\item \code{merge_setdiff}: returns sorted set x minus sorted set y
Default \code{method='unique'} returns a unique sorted set, see \code{\link{setdiff}}; 
\code{ethod='exact'} returns a sorted set with sum(x ties) minus sum(y ties);

\item \code{merge_symdiff}: returns those elements that are in sorted set \code{y} \code{\link{xor}} in sorted set \code{y}
Default \code{method='unique'} returns the sorted unique set complement, see \code{\link{symdiff}}; 
\code{method='exact'} returns a sorted set set complement with abs(sum(x ties) minus sum(y ties));

\item \code{merge_intersect}: returns the intersection of two sorted sets x and y
Default \code{method='unique'} returns the sorted unique intersect, see \code{\link{intersect}}; 
\code{method='exact'} returns the intersect with the minium number of ties in either set;

\item \code{merge_setequal}: returns \code{TRUE} for equal sorted sets and \code{FALSE} otherwise
Default \code{method='unique'} compares the sets after removing ties, see \code{\link{setequal}};  
\code{method='exact'} compares the sets without removing ties;

\item \code{merge_rangein}: returns logical existence of range rx in sorted set y, see \code{\link{merge_in}}

\item \code{merge_rangenotin}: returns logical in-existence of range rx in sorted set y, see \code{\link{merge_notin}}

\item \code{merge_rangesect}: returns the intersection of range rx and sorted set y, see \code{\link{merge_intersect}}

\item \code{merge_rangediff}: returns range rx minus sorted set y, see \code{\link{merge_setdiff}}

\item \code{merge_first}: quickly returns the first element of a sorted set x (or \code{NA} if x is empty), hence \code{x[1]} or \code{merge_rev(x)[1]}

\item \code{merge_last}: quickly returns the last element of a sorted set x, (or \code{NA} if x is empty), hence \code{x[n]} or \code{merge_rev(x)[n]}

\item \code{merge_firstin}: quickly returns the first common element of a range rx and a sorted set y, (or \code{NA} if the intersection is empty), hence \code{merge_first(merge_rangesect(rx,y))}

\item \code{merge_lastin}: quickly returns the last common element of a range rx and a sorted set y, (or \code{NA} if the intersection is empty), hence \code{merge_last(merge_rangesect(rx,y))}

\item \code{merge_firstnotin}: quickly returns the first element of a range rx which is not in a sorted set y (or \code{NA} if all rx are in y), hence \code{merge_first(merge_rangediff(rx,y))}

\item \code{merge_lastnotin}: quickly returns the last element of a range rx which is not in a sorted set y (or \code{NA} if all rx are in y), hence \code{merge_last(merge_rangediff(rx,y))}
}}

\note{
xx OPTIMIZATION OPPORTUNITY These are low-level functions could be optimized with initial binary search (not findInterval, which coerces to double).
}
\examples{
merge_rev(1:9)

merge_match(1:7, 3:9)
#' merge_match(merge_rev(1:7), 3:9)
merge_match(merge_rev(1:7), 3:9, revx=TRUE)
merge_match(merge_rev(1:7), 3:9, revy=TRUE)
merge_match(merge_rev(1:7), merge_rev(3:9))

merge_in(1:7, 3:9)
merge_notin(1:7, 3:9)

merge_anyDuplicated(c(1L,1L,2L,3L))
merge_duplicated(c(1L,1L,2L,3L))
merge_unique(c(1L,1L,2L,3L))

merge_union(c(1L,2L,2L,2L), c(2L,2L,3L))
merge_union(c(1L,2L,2L,2L), c(2L,2L,3L), method="exact")
merge_union(c(1L,2L,2L,2L), c(2L,2L,3L), method="all")

merge_setdiff(c(1L,2L,2L,2L), c(2L,2L,3L))
merge_setdiff(c(1L,2L,2L,2L), c(2L,2L,3L), method="exact")
merge_setdiff(c(1L,2L,2L), c(2L,2L,2L,3L), method="exact")

merge_symdiff(c(1L,2L,2L,2L), c(2L,2L,3L))
merge_symdiff(c(1L,2L,2L,2L), c(2L,2L,3L), method="exact")
merge_symdiff(c(1L,2L,2L), c(2L,2L,2L,3L), method="exact")

merge_intersect(c(1L,2L,2L,2L), c(2L,2L,3L))
merge_intersect(c(1L,2L,2L,2L), c(2L,2L,3L), method="exact")

merge_setequal(c(1L,2L,2L), c(1L,2L))
merge_setequal(c(1L,2L,2L), c(1L,2L,2L))
merge_setequal(c(1L,2L,2L), c(1L,2L), method="exact")
merge_setequal(c(1L,2L,2L), c(1L,2L,2L), method="exact")

}
