% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spca_randtest.R
\name{spca_randtest}
\alias{spca_randtest}
\title{Monte Carlo test for sPCA}
\usage{
spca_randtest(x, nperm = 499)
}
\arguments{
\item{x}{A \code{\link{spca}} object.}

\item{nperm}{The number of permutations to be used for the test.}
}
\value{
A list with two objects of the class 'randtest' (see
\code{\link[ade4]{as.randtest}}), the first one for 'global' structures
(positivie autocorrelation) and the second for 'local' structures (negative
autocorrelation).
}
\description{
The function \code{spca_randtest} implements Monte-Carlo tests for the
presence of significant spatial structures in a sPCA object. Two tests are
run, for global (positive autocorrelation) and local (negative
autocorrelation) structures, respectively. The test statistics used are the
sum of the absolute values of the corresponding eigenvalues.
}
\examples{

\dontrun{
## Load data
data(sim2pop)

## Make spca
spca1 <- spca(sim2pop, type = 1, scannf = FALSE, plot.nb = FALSE)

spca1
plot(spca1)

## run tests (use more permutations in practice, e.g. 999)
tests <- spca_randtest(spca1, nperm = 49)

## check results
tests
plot(tests[[1]]) # global structures

}

}
\author{
Original code by Valeria Montano adapted by Thibaut Jombart.
}
