% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRanges.R
\name{addExons}
\alias{addExons}
\title{Add exons to rowRanges of a transcript-level SummarizedExperiment}
\usage{
addExons(se)
}
\arguments{
\item{se}{the SummarizedExperiment}
}
\value{
a SummarizedExperiment
}
\description{
After running \code{tximeta}, the \code{SummarizedExperiment} output
will have \code{GRanges} representing the transcript locations
attached as \code{rowRanges} to the object. These provide the
start and end of the transcript in the genomic coordiantes, and
strand information. However, the exonic locations are not provided.
This function, \code{addExons}, swaps out the \code{GRanges}
with a \code{GRangesList}, essentially a list along the rows of the
\code{SummarizedExperiment}, where each element of the list is a
\code{GRanges} providing the locations of the exons for that transcript.
}
\details{
This function is designed only for transcript-level objects.
This "lack of a feature" reflects a belief on the part of the package author
that it makes more sense to think about exons belonging to transcripts
than to genes. For users desiring exonic information alongside
gene-level objects, for example, which exons are associated with
a particular gene, it is recommended to pull out the relevant
\code{GRangesList} for the transcripts of this gene, while the object
represents transcript-level data, such that the exons are still
associated with transcripts.

For an example of \code{addExons}, please see the tximeta vignette.
}
