% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions-VCF.R
\name{isSymbolic}
\alias{isSymbolic}
\alias{isSymbolic,CollapsedVCF-method}
\alias{isSymbolic,ExpandedVCF-method}
\title{Determining whether the variant is a symbolic allele.}
\usage{
isSymbolic(x, ...)

\S4method{isSymbolic}{CollapsedVCF}(x, ..., singleAltOnly = TRUE)

\S4method{isSymbolic}{ExpandedVCF}(x, ...)
}
\arguments{
\item{x}{A VCF object.}

\item{...}{Internal parameters.}

\item{singleAltOnly}{Whether only single ALT values are accepted. Default is
set to TRUE.}
}
\value{
A logical list of which the length is the same with the input object.
}
\description{
Determining whether the variant is a symbolic allele.
}
\details{
The function takes a VCF object as input, and returns a logical
value for each row, determining whether the variant is a symbolic allele.
}
\section{Methods (by class)}{
\itemize{
\item \code{CollapsedVCF}: Determining whether a CollapsedVCF object is a symbolic 
allele. Only single ALT values are accepted.

\item \code{ExpandedVCF}: Determining whether a ExpandedVCF object is a symbolic 
allele
}}

\examples{
vcf.file <- system.file("extdata", "gridss.vcf", package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
isSymbolic(vcf)
}
