% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot heatmap of gene expression values}
\usage{
plotHeatmap(
  object,
  features,
  columns = NULL,
  exprs_values = "logcounts",
  center = FALSE,
  zlim = NULL,
  symmetric = FALSE,
  color = NULL,
  colour_columns_by = NULL,
  column_annotation_colors = list(),
  order_columns_by = NULL,
  by_exprs_values = exprs_values,
  show_colnames = FALSE,
  cluster_cols = is.null(order_columns_by),
  swap_rownames = NULL,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object.}

\item{features}{A character vector of row names, a logical vector of integer vector of indices specifying rows of \code{object} to show in the heatmap.}

\item{columns}{A vector specifying the subset of columns in \code{object} to show as columns in the heatmap. 
Also specifies the column order if \code{cluster_cols=FALSE} and \code{order_columns_by=NULL}.
By default, all columns are used.}

\item{exprs_values}{A string or integer scalar indicating which assay of \code{object} should be used as expression values for colouring in the heatmap.}

\item{center}{A logical scalar indicating whether each row should have its mean expression centered at zero prior to plotting.}

\item{zlim}{A numeric vector of length 2, specifying the upper and lower bounds for the expression values. 
This winsorizes the expression matrix prior to plotting (but after centering, if \code{center=TRUE}). 
If \code{NULL}, it defaults to the range of the expression matrix.}

\item{symmetric}{A logical scalar specifying whether the default \code{zlim} should be symmetric around zero. 
If \code{TRUE}, the maximum absolute value of \code{zlim} will be computed and multiplied by \code{c(-1, 1)} to redefine \code{zlim}.}

\item{color}{A vector of colours specifying the palette to use for mapping expression values to colours. 
This defaults to the default setting in \code{\link[pheatmap]{pheatmap}}.}

\item{colour_columns_by}{A list of values specifying how the columns should be annotated with colours.
Each entry of the list can be any acceptable input to the \code{by} argument in \code{?\link{retrieveCellInfo}}.
A character vector can also be supplied and will be treated as a list of strings.}

\item{column_annotation_colors}{A named list of color scales to be used for
the column annotations specified in \code{colour_columns_by}. Names
should be character values present in \code{colour_columns_by},
If a color scale is not specified for a particular annotation, a default
color scale is chosen.
The full list of colour maps is passed to \code{\link[pheatmap]{pheatmap}} 
as the \code{annotation_colours} argument.}

\item{order_columns_by}{A list of values specifying how the columns should be ordered.
Each entry of the list can be any acceptable input to the \code{by} argument in \code{?\link{retrieveCellInfo}}.
A character vector can also be supplied and will be treated as a list of strings.
This argument is automatically appended to \code{colour_columns_by}.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from, 
for colouring of column-level data - see the \code{exprs_values} argument in \code{?\link{retrieveCellInfo}}.}

\item{show_colnames, cluster_cols, ...}{Additional arguments to pass to \code{\link[pheatmap]{pheatmap}}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}
}
\value{
A heatmap is produced on the current graphics device. 
The output of \code{\link[pheatmap]{pheatmap}} is invisibly returned.
}
\description{
Create a heatmap of expression values for each cell and specified features in a SingleCellExperiment object.
}
\details{
Setting \code{center=TRUE} is useful for examining log-fold changes of each cell's expression profile from the average across all cells.
This avoids issues with the entire row appearing a certain colour because the gene is highly/lowly expressed across all cells.

Setting \code{zlim} preserves the dynamic range of colours in the presence  of outliers. 
Otherwise, the plot may be dominated by a few genes, which will \dQuote{flatten} the observed colours for the rest of the heatmap.

Setting \code{order_columns_by} is useful for automatically ordering the heatmap by one or more factors of interest, e.g., cluster identity.
This the need to set \code{colour_columns_by}, \code{cluster_cols} and \code{columns} to achieve the same effect.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)

plotHeatmap(example_sce, features=rownames(example_sce)[1:10])

plotHeatmap(example_sce, features=rownames(example_sce)[1:10],
    center=TRUE, symmetric=TRUE)

plotHeatmap(example_sce, features=rownames(example_sce)[1:10],
    colour_columns_by=c("Mutation_Status", "Cell_Cycle"))

}
\seealso{
\code{\link[pheatmap]{pheatmap}}
}
\author{
Aaron Lun
}
