% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_top_weights}
\alias{plot_top_weights}
\title{Plot top weights}
\usage{
plot_top_weights(
  object,
  view = 1,
  factors = 1,
  nfeatures = 10,
  abs = TRUE,
  scale = TRUE,
  sign = "all"
)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{view}{a string with the view name, or an integer with the index of the view.}

\item{factors}{a character string with factors names, or an integer vector with factors indices.}

\item{nfeatures}{number of top features to display.
Default is 10}

\item{abs}{logical indicating whether to use the absolute value of the weights (Default is FALSE).}

\item{scale}{logical indicating whether to scale all weights from -1 to 1 (or from 0 to 1 if abs=TRUE). Default is TRUE.}

\item{sign}{can be 'positive', 'negative' or 'all' to show only positive, negative or all weights, respectively. Default is 'all'.}
}
\value{
Returns a \code{ggplot2} object
}
\description{
Plot top weights for a given factor and view.
}
\details{
An important step to annotate factors is to visualise the corresponding feature weights. \cr
This function displays the top features with highest loading whereas the function \code{\link{plot_top_weights}} plots all weights for a given latent factor and view. \cr
Importantly, the weights of the features within a view have relative values and they should not be interpreted in an absolute scale.
Therefore, for interpretability purposes we always recommend to scale the weights with \code{scale=TRUE}.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Plot top weights for Factors 1 and 2 and View 1
plot_top_weights(model, view = 1, factors = c(1,2))

# Do not take absolute value
plot_weights(model, abs = FALSE)

}
