% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast5Readers.R
\name{readFast5Log}
\alias{readFast5Log}
\title{Read the log entry from a single fast5 file}
\usage{
readFast5Log(file)
}
\arguments{
\item{file}{Character vector of fast5 file to be read.}
}
\value{
Character vector containing the log information.  
\code{NULL} if no log is found.
}
\description{
Basecalling procedures performed on fast5 files generally leave a 
log file entry recording how far through the pipeline the file 
proceeded.  This function will extract this information as a 
single string.  It can be printed in a more readable format 
using the \code{\link{cat}} function.
}
\examples{
fast5file <- system.file('extdata', 'example.fast5', package = "IONiseR")
log <- readFast5Log(fast5file)
cat(log)
}
