\name{read.SDFindex}
\alias{read.SDFindex}
\title{
Extract Molecules from SD File by Line Index
}
\description{
Extracts specific molecules from SD File based on a line position index computed by the \code{sdfStream} function.
}
\usage{
read.SDFindex(file, index, type = "SDFset", outfile)
}
\arguments{
  \item{file}{
file name of source SD file used to generate \code{index}
}
  \item{index}{
data frame containing in the first two columns the start and end positions (index) of molecules in an SD File, respectively. Typically, this index would be imported with \code{read.table/read.delim} from a tabular descriptor file generated by the \code{sdfStream} function. 
}
  \item{type}{
if \code{type="file"}, the SDF output will be written to a file named as specified under \code{outfile}; if \code{type="SDFset"}, the SDF data is collected will be a \code{SDFset} container.
}
  \item{outfile}{
name of output file when \code{type="file"}
}
}
\details{
...
}
\value{
Writes molecules in SDF format to file or collects them in \code{SDFset} container.
}
\references{
SDF format definition: http://www.symyx.com/downloads/public/ctfile/ctfile.jsp
}
\author{
Thomas Girke
}
\seealso{
Import/export functions: \code{read.SDFset}, \code{read.SDFstr}, \code{read.SDFstr}, \code{read.SDFset}, \code{write.SDFsplit}
}
\examples{
## Load sample data
library(ChemmineR)
data(sdfsample); sdfset <- sdfsample
\dontrun{write.SDF(sdfset, "test.sdf")

## Define descriptor set in a simple function
desc <- function(sdfset) {
        cbind(SDFID=sdfid(sdfset), 
              # datablock2ma(datablocklist=datablock(sdfset)), 
              MW=MW(sdfset), 
              groups(sdfset), 
              # AP=sdf2ap(sdfset, type="character"),
              rings(sdfset, type="count", upper=6, arom=TRUE)
        )
}

## Run sdfStream with desc function and write results to a file called 'matrix.xls'
sdfStream(input="test.sdf", output="matrix.xls", fct=desc, Nlines=1000)

## Select molecules from SD File using line index from sdfStream
indexDF <- read.delim("matrix.xls", row.names=1)[,1:4]
indexDFsub <- indexDF[indexDF$MW < 400, ] # Selects molecules with MW < 400
sdfset <- read.SDFindex(file="test.sdf", index=indexDFsub, type="SDFset")

## Write result directly to SD file without storing larger numbers of molecules in memory
read.SDFindex(file="test.sdf", index=indexDFsub, type="file", outfile="sub.sdf")
}
}
\keyword{ utilities }
