// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: regexp_test.cpp,v 1.9 2012/05/21 03:20:39 vlg Exp $
//------------------------------------------------------------------------------
//                            RegexpTest.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2003,2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
//
// Date   : Mon Sep  1 14:40:40 2003
//
//------------------------------------------------------------------------------

static const char help_msg[]=
"                                                                            \n"
" NAME:                                                                      \n"
"                                                                            \n"
"   regexp_test                                                              \n"
"                                                                            \n"
" DESCRIPTION:                                                               \n"
"                                                                            \n"
"   Test driver for Regexp class.                                            \n"
"                                                                            \n"
" USAGE:                                                                     \n"
"                                                                            \n"
"   shell> regexp_test [OPTIONS]                                             \n"
"                                                                            \n"
" OPTIONS:                                                                   \n"
"                                                                            \n"
" -D, --log-file NAME     - Write debug to NAME file                         \n"
" -d, --log-stdout        - Write debug to standard output                   \n"
" -z, --log-size NUM      - Maximum size debug file can reach (dfl: is 10Mb) \n"
"                                                                            \n"
" -c, --log-level NUM     - Log verbosity                                    \n"
" -s, --with-log-server   - Redirect log messages to the log server          \n"
" -S, --log-server NAME   - Define assa-logd server address                  \n"
"                                                                            \n"
" -m, --mask MASK         - Mask (default: ALL = 0x7fffffff)                 \n"
"                                                                            \n"
" -h, --help              - Print this messag                                \n"
" -v, --version           - Print version number                            \n";
//------------------------------------------------------------------------------

#include <iostream>
#include <assa/Assure.h>
#include <assa/Regexp.h>

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif
#include <string>
using std::string;

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>

enum { RGXP_TEST = ASSA::USR1 };

class RegexpTest :
    public ASSA::GenServer,
    public ASSA::Singleton<RegexpTest>
{
public:
    RegexpTest ();

    virtual void init_service ();
    virtual void process_events ();

private:
};

/* Useful definitions */

#define REGEXPTEST  RegexpTest::get_instance()
#define REACTOR     REGEXPTEST->get_reactor()

// Static declarations mandated by Singleton class
ASSA_DECL_SINGLETON(RegexpTest);

RegexpTest::
RegexpTest ()
{
    // ---Configuration---
    rm_opt ('f', "config-file"  );
    rm_opt ('n', "instance"     );
    rm_opt ('p', "port"         );

    // ---Process bookkeeping---
    rm_opt ('b', "daemon"       );
    rm_opt ('l', "pidfile"      );
    rm_opt ('L', "ommit-pidfile");

    m_ommit_pidfile = "yes";

    /*---
     * By defauil disable all debugging
     *---*/
    /* m_mask = ASSA::APP | ASSA::ASSAERR | ASSA::TRACE;
       m_log_file = "regexp_test.log";
    */

    m_mask = RGXP_TEST;
	m_log_stdout = "yes";
}

void
RegexpTest::
init_service ()
{
    /* no-op */
}

void
RegexpTest::
process_events ()
{
//    trace("RegexpTest::process_events");

    const char* test[] = {
		"# Comment line",		    // 0
		"",						    // 1
		"[Options]",			    // 2
		"mask=0x0",				    // 3
		"  daemon = true",		    // 4
		"\tgtk_options=--g-fatal-warnings --disable-crash-dialog", // 5
		"",						    // 6
		" ]Not a valid section [",  // 7
		"not a valid pair "		    // 8
    };

    DL((RGXP_TEST,"= Running regexp_test Test =\n"));

    ASSA::Regexp section_pattrn ("\\[[a-zA-Z0-9]+.*]$");
    ASSA::Regexp pair_pattrn ("^[ \t]*[a-zA-Z0-9]+.* *= *.*");

    DL((RGXP_TEST,"Testing comment match ... "));

    if (section_pattrn.match (test [0]) == 0) {
		DL((RGXP_TEST," failed to discard comment!\n"));
		goto failed;
    }
    DL((RGXP_TEST,"ok\n"));

    DL((RGXP_TEST,"Testing section match ... "));
    if (section_pattrn.match (test [2]) < 0) {
		DL((RGXP_TEST," failed to match valid section!\n"));
		DL((RGXP_TEST," error: \"%s\"\n", section_pattrn.get_error ()));
		goto failed;
    }

    if (section_pattrn.match (test [7]) == 0) {
		DL((RGXP_TEST," failed to reject invalid section!\n"));
		goto failed;
    }
    DL((RGXP_TEST,"ok\n"));

    DL((RGXP_TEST,"Testing name/value pair match ... "));
    for (int i = 3; i < 6; i++) {
		if (pair_pattrn.match (test [i]) < 0) {
			DL((RGXP_TEST,
				" failed to match valid name/value pair!\n"
				" input: \"%s\"\n"
				" error: %s",
				test [i],
				section_pattrn.get_error ()));
			goto failed;
		}
    }
    DL((RGXP_TEST,"ok\n"));

    DL((RGXP_TEST,"Testing name/value pair reject ... "));
    if (pair_pattrn.match (test [8]) == 0) {
		DL((RGXP_TEST," failed to reject invalid name/value pair!\n"));
		goto failed;
    }
    DL((RGXP_TEST,"ok\n"));

    // Shut the service down
    DL((ASSA::APP,"Service stopped!\n"));
    DL((RGXP_TEST,"= Test passed =\n"));
    m_reactor.stopReactor ();
    return;

 failed:

    set_exit_value (1);
    DL((RGXP_TEST,"= Test failed =\n"));
    m_reactor.stopReactor ();
}

int
main (int argc, char* argv[])
{
    static const char release[] = "1.0";
    int patch_level = 0;

    REGEXPTEST->set_version (release, patch_level);
    REGEXPTEST->set_author  ("Vladislav Grinchenko");
    REGEXPTEST->set_flags   (ASSA::GenServer::RMLOG);

    REGEXPTEST->init (&argc, argv, help_msg);

    REGEXPTEST->init_service ();
    REGEXPTEST->process_events ();

    return REGEXPTEST->get_exit_value ();
}

