# NAME

klutshnikd.cfg - configuration for for klutshnik KMS server `klutshnikd`

# DESCRIPTION

`klutshnikd.cfg` holds the configuration for the klutshnik KMS
**server**.

The server looks for the configuration in the following files and order:

  - /etc/klutshnikd/config
  - ~/.config/klutshnikd/config
  - ~/.klutshnikdrc
  - ./klutshnikd.cfg

The configuration file format is TOML, see https://toml.io/ .

## `[server]` SECTION

This section contains all the settings for the server.

### ADDRESS

This can be either an IPv4 or IPv6 address to listen on. Default: 127.0.0.1

### PORT

The port the server listens on.

If you run a server that is publicly available on the internet, it is
recommended to run it on port 443, which - if you ever go to a restricted
network environment - has the biggest chances that a firewall will allow to
access this. Default: 443

### `SSL_KEY` & `SSL_SERVER`

These two settings point at files containing the PEM encoded SSL certificate
and key of the server.

In the times of Let's Encrypt this should not be a big challenge. You do need a
domain name you control for this though, but that is a requirement for public
servers anyway. If you have a domain name, you can run on that host something
like this:

```sh
sudo certbot certonly --standalone --preferred-challenges http -d example.com
```

If you cannot get a proper CA signed certificate the client also
supports using self-signed certificates, but that should only be used
in development, isolated or VPN environments.

### TIMEOUT

This configures the timeouts for the server. In order to minimize resource
exhaustion attack this should be kept as small as possible, but also big enough
for clients to answer in time. Since all the messages are very small, something
in the low one-digit seconds ballpark should be ample. Default 3s.

### DATADIR

This variable contains the path to the directory where all the
key-related data is stored. Default: `/var/lib/klutshnikd`

### `MAX_KIDS`

This setting configures the maximum of how many handlers (sessions) to run in
parallel. Default: 5

### VERBOSE

This setting increases the messages the server prints out during operation.

### `RECORD_SALT`

This is a value that internally hashes the record Ids provided by clients. It
should be changed upon installation to a fresh unique value.

### `TS_EPSILON`

This setting defines how long a message is considered fresh during a DKG
protocol, any messages that have timestamps that are older than this many
seconds will abort the DKG protocol. Increase this value if you have/expect
laggy links. Default: 600s

### LTSIGKEY

This setting points at a file containing the long-term signing key of
the server. The key can be generated by running the `klutshnikd(1)`
client with the `init` parameter:

```sh
$ klutshnikd init
```

You need to publish this so that users can use your server.

### NOISEKEY

This setting points at a file containing the long-term Noise key of
the server. The key can be generated by running the `klutshnikd(1)`
client with the `init` parameter:

```sh
$ klutshnikd init
```

You need to publish this so that users can use your server.

### AUTHORIZED_KEYS

This variable points at a file, containing a list of long-term signing
public keys for other KMS servers. This is checked on create and
key-rotation operations, when the servers are establishing contact
with each other.

# FILES

  - /etc/klutshnikd/config
  - ~/.config/klutshnikd/config
  - ~/.klutshnikdrc
  - ./klutshnikd.cfg

# SECURITY CONSIDERATIONS

You **should** back up securely your ltsigkey, noisekey, your SSL cert
and key, and the value of your `RECORD_SALT` setting.

# REPORTING BUGS

https://github.com/stef/klutshnik/issues/

# AUTHOR

Written by Stefan Marsiske.

# COPYRIGHT

Copyright © 2024 Stefan Marsiske.  License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>.
This is free software: you are free to change and redistribute it.  There is NO WARRANTY, to the extent permitted by law.

# SEE ALSO

`klutshnikd(1)`, `klutshnik(1)`, `klutshnik.cfg(5)`
