#! /bin/sh

n=$(expr $(head -1 debian/changelog | awk '{printf $2}' | /usr/bin/wc -c) - 1)
version=$(head -1 debian/changelog | awk '{printf $2}' | cut -b2-$n)
upstream_version=$(echo $version | awk -F "-" '{printf $1}')
debian_revision=$(echo $version | awk -F "-" '{printf $2}')

package_branch=main-$upstream_version-$debian_revision
upstream_branch=l$upstream_version
debian_branch=debian

git br -D $package_branch 2> /dev/null
git br $package_branch $debian_branch
git co $package_branch
git merge $upstream_branch -m "Merging upstream branch"

debuild -us -uc -I.git $@

