# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-firefox-view =
    .label = { -firefoxview-brand-name }
    .tooltiptext = { -firefoxview-brand-name }
toolbar-button-firefox-view-2 =
    .label = { -firefoxview-brand-name }
    .tooltiptext = Afficher l’historique de navigation récent des diverses fenêtres et différents appareils
menu-tools-firefox-view =
    .label = { -firefoxview-brand-name }
    .accesskey = F
firefoxview-page-title = { -firefoxview-brand-name }
firefoxview-page-heading =
    .heading = { -firefoxview-brand-name }
firefoxview-page-label =
    .label = { -firefoxview-brand-name }
firefoxview-close-button =
    .title = Fermer
    .aria-label = Fermer
firefoxview-empty-state-icon =
    .alt = Attention :
# Used instead of the localized relative time when a timestamp is within a minute or so of now
firefoxview-just-now-timestamp = À l’instant
# This is a headline for an area in the product where users can resume and re-open tabs they have previously viewed on other devices.
firefoxview-tabpickup-header = Récupération d’onglets
firefoxview-tabpickup-description = Ouvrez des pages provenant d’autres appareils.
# Variables:
#  $percentValue (Number): the percentage value for setup completion
firefoxview-tabpickup-progress-label = Terminé à { $percentValue } %
firefoxview-tabpickup-step-signin-header = Passez facilement d’un appareil à l’autre
firefoxview-tabpickup-step-signin-description = Pour récupérer les onglets de votre téléphone ici, commencez par vous connecter ou créer un compte.
firefoxview-tabpickup-step-signin-primarybutton = Continuer
firefoxview-syncedtabs-signin-header-2 = Votre { -brand-product-name } sur tous vos appareils
firefoxview-syncedtabs-signin-description-2 = Pour afficher les onglets ouverts sur votre téléphone et vos autres appareils, connectez-vous ou créez un compte. Avec un compte, vous pouvez également synchroniser mots de passe, historique et plus encore.
firefoxview-syncedtabs-signin-primarybutton-2 = Connexion
firefoxview-syncedtabs-signin-header = Récupérez vos onglets où que vous soyez
firefoxview-syncedtabs-signin-description = Pour consulter vos onglets où que vous utilisiez { -brand-product-name }, connectez-vous à votre compte. Si vous n’avez pas de compte, nous vous guiderons à chaque étape de l’inscription.
firefoxview-syncedtabs-signin-primarybutton = S’inscrire ou se connecter
firefoxview-tabpickup-adddevice-header = Synchronisez { -brand-product-name } avec votre téléphone ou votre tablette
firefoxview-tabpickup-adddevice-description = Téléchargez { -brand-product-name } pour mobile et connectez-vous.
firefoxview-tabpickup-adddevice-learn-how = Découvrez comment
firefoxview-tabpickup-adddevice-primarybutton = Installez { -brand-product-name } sur votre appareil mobile
firefoxview-syncedtabs-adddevice-header-2 = Récupérez vos onglets où que vous soyez
firefoxview-syncedtabs-adddevice-description-2 = Connectez-vous à { -brand-product-name } sur votre téléphone ou un autre ordinateur pour afficher leurs onglets ici. Découvrez comment <a data-l10n-name="url">connecter des appareils supplémentaires</a>.
firefoxview-syncedtabs-adddevice-header = Connectez-vous à { -brand-product-name } sur vos autres appareils
firefoxview-syncedtabs-adddevice-description = Pour consulter vos onglets où que vous utilisiez { -brand-product-name }, connectez-vous sur tous vos appareils. Découvrez comment <a data-l10n-name="url">connecter des appareils supplémentaires</a>.
firefoxview-syncedtabs-adddevice-primarybutton = Essayer { -brand-product-name } pour mobile
firefoxview-tabpickup-synctabs-header = Activez la synchronisation des onglets
firefoxview-tabpickup-synctabs-description = Autorisez { -brand-short-name } à partager les onglets entre vos appareils.
firefoxview-tabpickup-synctabs-learn-how = Me montrer comment faire
firefoxview-tabpickup-synctabs-primarybutton = Synchroniser les onglets ouverts
firefoxview-syncedtabs-synctabs-header = Mettez à jour vos paramètres de synchronisation
firefoxview-syncedtabs-synctabs-description = Pour consulter les onglets d’autres appareils, vous devez synchroniser vos onglets ouverts.
firefoxview-syncedtabs-synctabs-checkbox = Autoriser la synchronisation des onglets ouverts
firefoxview-syncedtabs-loading-header = Synchronisation en cours
firefoxview-syncedtabs-loading-description = Une fois terminée, vous verrez ici tous les onglets ouverts sur vos autres appareils. Revenez vite.
firefoxview-tabpickup-fxa-admin-disabled-header = Votre organisation a désactivé la synchronisation
firefoxview-tabpickup-fxa-admin-disabled-description = { -brand-short-name } ne peut pas synchroniser d’onglets entre appareils car votre administrateur·trice a désactivé la synchronisation.
firefoxview-tabpickup-fxa-disabled-by-policy-description = { -brand-short-name } ne peut pas synchroniser d’onglets entre appareils car votre organisation a désactivé la synchronisation.
firefoxview-tabpickup-network-offline-header = Vérifiez votre connexion à Internet
firefoxview-tabpickup-network-offline-description = Si vous utilisez un pare-feu ou un proxy, vérifiez que { -brand-short-name } a l’autorisation d’accéder au Web.
firefoxview-tabpickup-network-offline-primarybutton = Réessayer
firefoxview-tabpickup-sync-error-header = Nous rencontrons des problèmes de synchronisation
firefoxview-tabpickup-generic-sync-error-description = { -brand-short-name } ne peut pas joindre le service de synchronisation pour l’instant. Réessayez dans quelques instants.
firefoxview-tabpickup-sync-error-primarybutton = Réessayer
firefoxview-tabpickup-sync-disconnected-header = Activez la synchronisation pour continuer
firefoxview-tabpickup-sync-disconnected-description = Pour récupérer vos onglets, vous devez autoriser la synchronisation dans { -brand-short-name }.
firefoxview-tabpickup-sync-disconnected-primarybutton = Activer la synchronisation dans les paramètres
firefoxview-tabpickup-password-locked-header = Saisissez votre mot de passe principal pour afficher les onglets
firefoxview-tabpickup-password-locked-description = Pour récupérer vos onglets, vous devez saisir le mot de passe principal de { -brand-short-name }.
firefoxview-tabpickup-password-locked-link = En savoir plus
firefoxview-tabpickup-password-locked-primarybutton = Saisir le mot de passe principal
firefoxview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">En savoir plus</a>
firefoxview-tabpickup-signed-out-header = Identifiez-vous pour vous reconnecter
firefoxview-tabpickup-signed-out-description = Pour vous reconnecter et récupérer vos onglets, connectez-vous à votre { -fxaccount-brand-name }.
firefoxview-tabpickup-signed-out-description2 = Pour vous reconnecter et récupérer vos onglets, connectez-vous à votre compte.
firefoxview-tabpickup-signed-out-primarybutton = Se connecter
firefoxview-tabpickup-syncing = Veuillez patienter pendant la synchronisation de vos onglets. Ce ne sera pas long.
firefoxview-mobile-promo-header = Récupérez les onglets de votre téléphone ou de votre tablette
firefoxview-mobile-promo-description = Pour afficher les derniers onglets de votre appareil mobile, connectez-vous à { -brand-product-name } sous iOS ou Android.
firefoxview-mobile-promo-primarybutton = Installez { -brand-product-name } sur votre appareil mobile
firefoxview-mobile-confirmation-header = 🎉 C’est parti !
firefoxview-mobile-confirmation-description = Vous pouvez maintenant récupérer les onglets du { -brand-product-name } de votre tablette ou votre téléphone.
firefoxview-closed-tabs-title = Récemment fermés
firefoxview-closed-tabs-description2 = Rouvrez des pages que vous avez fermées dans cette fenêtre.
firefoxview-closed-tabs-placeholder-header = Aucun onglet récemment fermé
firefoxview-closed-tabs-placeholder-body = Si vous avez fermé un onglet de cette fenêtre, vous pouvez le récupérer ici.
firefoxview-closed-tabs-placeholder-body2 = Si vous avez fermé un onglet, vous pouvez le récupérer ici.
# Variables:
#   $tabTitle (string) - Title of tab being dismissed
firefoxview-closed-tabs-dismiss-tab =
    .title = Retirer { $tabTitle }
# refers to the last tab that was used
firefoxview-pickup-tabs-badge = Dernier onglet actif
# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
firefoxview-tabs-list-tab-button =
    .title = Ouvrir { $targetURI } dans un nouvel onglet
firefoxview-try-colorways-button = Essayer les coloris
firefoxview-change-colorway-button = Changer de coloris
# Variables:
#  $intensity (String): Colorway intensity
#  $collection (String): Colorway Collection name
firefoxview-colorway-description = { $intensity } · { $collection }
firefoxview-synced-tabs-placeholder-header = Rien à voir pour l’instant
firefoxview-synced-tabs-placeholder-body = La prochaine fois que vous ouvrez une page dans { -brand-product-name } sur un autre appareil, retrouvez-la ici comme par magie.
firefoxview-collapse-button-show =
    .title = Afficher la liste
firefoxview-collapse-button-hide =
    .title = Masquer la liste
firefoxview-overview-nav = Navigation récente
    .title = Navigation récente
firefoxview-overview-header = Navigation récente
    .title = Navigation récente

## History in this context refers to browser history

firefoxview-history-nav = Historique
    .title = Historique
firefoxview-history-header = Historique
firefoxview-history-context-delete = Supprimer de l’historique
    .accesskey = S

## Open Tabs in this context refers to all open tabs in the browser

firefoxview-opentabs-nav = Onglets ouverts
    .title = Onglets ouverts
firefoxview-opentabs-header = Onglets ouverts

## Recently closed tabs in this context refers to recently closed tabs from all windows

firefoxview-recently-closed-nav = Onglets récemment fermés
    .title = Onglets récemment fermés
firefoxview-recently-closed-header = Onglets récemment fermés

## Tabs from other devices refers in this context refers to synced tabs from other devices

firefoxview-synced-tabs-nav = Onglets d’autres appareils
    .title = Onglets d’autres appareils
firefoxview-synced-tabs-header = Onglets d’autres appareils

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of Firefox View
firefoxview-view-all-link = Tout afficher
# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
firefoxview-opentabs-window-header =
    .title = Fenêtre { $winID }
# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
firefoxview-opentabs-current-window-header =
    .title = Fenêtre { $winID } (actuelle)
firefoxview-opentabs-focus-tab =
    .title = Basculer vers cet onglet
firefoxview-show-more = En afficher plus
firefoxview-show-less = En afficher moins
firefoxview-show-all = Tout afficher
firefoxview-search-text-box-clear-button =
    .title = Effacer
# Placeholder for the input field to search in recent browsing ("search" is a verb).
firefoxview-search-text-box-recentbrowsing =
    .placeholder = Rechercher
# Placeholder for the input field to search in history ("search" is a verb).
firefoxview-search-text-box-history =
    .placeholder = Rechercher dans l’historique
# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
firefoxview-search-text-box-recentlyclosed =
    .placeholder = Rechercher dans les onglets récemment fermés
# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
firefoxview-search-text-box-tabs =
    .placeholder = Rechercher dans les onglets
# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
firefoxview-search-text-box-syncedtabs =
    .placeholder = Rechercher parmi les onglets synchronisés
# Placeholder for the input field to search in open tabs ("search" is a verb).
firefoxview-search-text-box-opentabs =
    .placeholder = Rechercher parmi les onglets ouverts
# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
firefoxview-search-results-header = Résultats de la recherche pour « { $query } »
# Variables:
#   $count (Number) - The number of visits matching the search query.
firefoxview-search-results-count =
    { $count ->
        [one] { $count } site
       *[other] { $count } sites
    }
# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
firefoxview-search-results-empty = Pas de résultats pour « { $query } »
firefoxview-sort-history-by-date-label = Trier par date
firefoxview-sort-history-by-site-label = Trier par site
firefoxview-sort-open-tabs-by-recency-label = Trier par activité récente
firefoxview-sort-open-tabs-by-order-label = Trier par onglets
# Variables:
#   $url (string) - URL that will be opened in the new tab
firefoxview-opentabs-tab-row =
    .title = Aller vers { $url }

## Variables:
##   $date (string) - Date to be formatted based on locale

firefoxview-history-date-today = Aujourd’hui – { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-yesterday = Hier – { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }
# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
firefoxview-history-site-localhost = (fichiers locaux)

##

firefoxview-show-all-history = Afficher tout l’historique
firefoxview-view-more-browsing-history = Afficher plus d’historique de navigation

## Message displayed in Firefox View when the user has no history data

firefoxview-history-empty-header = Reprenez là où vous en étiez
firefoxview-history-empty-description = Au cours de votre navigation, les pages visitées seront répertoriées ici.
firefoxview-history-empty-description-two = La protection de votre vie privée est notre priorité. C’est la raison pour laquelle vous pouvez contrôler les activités dont { -brand-short-name } garde trace dans vos <a data-l10n-name="history-settings-url">paramètres d’historique</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
firefoxview-choose-browser-button = Choisir le navigateur
    .title = Choisir le navigateur

## Message displayed in Firefox View when the user has chosen to never remember History

firefoxview-dont-remember-history-empty-header = Rien à afficher
firefoxview-dont-remember-history-empty-description = La protection de votre vie privée est notre priorité. C’est la raison pour laquelle vous pouvez contrôler les activités dont { -brand-short-name } garde trace.
firefoxview-dont-remember-history-empty-description-two = D’après vos paramètres actuels, { -brand-short-name } ne conserve aucune trace de vos activités de navigation. Pour changer cela, <a data-l10n-name="history-settings-url-two">modifiez vos paramètres d’historique pour conserver votre historique de navigation</a>.
firefoxview-dont-remember-history-empty-header-2 = Vous contrôlez ce que { -brand-short-name } mémorise
firefoxview-dont-remember-history-empty-description-one = Pour l’instant, { -brand-short-name } ne mémorise pas votre navigation. Pour changer cela, <a data-l10n-name="history-settings-url-two">modifiez vos paramètres d’historique</a>.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in Firefox View
firefoxview-import-history-close-button =
    .aria-label = Fermer
    .title = Fermer

## Text displayed in a dismissable banner to import bookmarks/history from another browser

firefoxview-import-history-header = Importer l’historique d’un autre navigateur
firefoxview-import-history-description = Faites de { -brand-short-name } votre navigateur par défaut. Importez l’historique de navigation, les marque-pages, etc.

## Message displayed in Firefox View when the user has no recently closed tabs data

firefoxview-recentlyclosed-empty-header = Vous avez fermé un onglet par erreur ?
firefoxview-recentlyclosed-empty-description = Vous trouverez ici les onglets que vous avez récemment fermés, afin de pouvoir les rouvrir rapidement.
firefoxview-recentlyclosed-empty-description-two = Pour retrouver des onglets plus anciens, consultez votre <a data-l10n-name="history-url">historique de navigation</a>.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

firefoxview-syncedtabs-device-notabs = Aucun onglet ouvert sur cet appareil
firefoxview-syncedtabs-connect-another-device = Connecter un autre appareil
firefoxview-pinned-tabs =
    .title = Onglets épinglés
firefoxview-tabs =
    .title = Onglets

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

firefoxview-opentabs-pinned-tab =
    .title = Aller sur { $tabTitle }
# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-pinned-tab =
    .title = Aller sur { $tabTitle } (dans les marque-pages)

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-tab =
    .title = { $url } (dans les marque-pages)
