# Guides
In this part of the wiki, you will find everything you need to get going with writing code in UniMath.

## Tutorials
If you are new to UniMath, we recommend to take a look at the tutorials. You can also use them as a cheat sheet to quickly find (the names of) the most important lemmas and definitions for working with a concept.

1. [Type Formers in UniMath](./tutorials/t01-type-formers.md)
2. [Reasoning with paths](./tutorials/t02-paths.md)
3. [Equivalences between types](./tutorials/t03-equivalences.md)
4. [Propositions and Sets: homotopy types](./tutorials/t04-htypes.md)
5. [Category Theory](./tutorials/t05-category-theory.md)
6. [Working with transports](./tutorials/t06-transports.md)

## Other guides
In this folder, you will also find guides on a couple of separate topics:
* [A cheat sheet for tactics and some tricks for writing proofs](./Tactics-and-tricks.md);
* [Opaqueness of definitions and lemmas](./Opaqueness.md);
* [Scripts and snippets that may assist when working with UniMath](./Scripts-and-snippets.md);
* [The standard API for a type](./The-standard-API-for-a-type.md).

## FAQ
* [Help, my proof is slow!](./faq/Slow-proof.md)

## Relevant reading
UniMath has a somewhat complicated theoretical foundation. Here are some links to related reading that may help you understand better how any of this works.

* For a short introduction to what univalent foundations is about, see ["An introduction to univalent foundations for mathematicians" by Daniel Grayson](https://arxiv.org/pdf/1711.01477).
* For a more comprehensive text about homotopy type theory and univalent foundations, see [the HoTT book](https://homotopytypetheory.org/book/)
* You can find a lot of material about category theory on [Nlab](https://ncatlab.org/).
