//===----------------------------------------------------------------------===//
//
// Part of libcu++, the C++ Standard Library for your entire system,
// under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// SPDX-FileCopyrightText: Copyright (c) 2024 NVIDIA CORPORATION & AFFILIATES.
//
//===----------------------------------------------------------------------===//
// <memory>

// unique_ptr

// test op->()

#include <cuda/std/__memory_>
#include <cuda/std/cassert>

#include "test_macros.h"

struct A
{
  int i_;

  __host__ __device__ TEST_CONSTEXPR_CXX23 A()
      : i_(7)
  {}
};

__host__ __device__ TEST_CONSTEXPR_CXX23 bool test()
{
  cuda::std::unique_ptr<A> p(new A);
  assert(p->i_ == 7);

  return true;
}

int main(int, char**)
{
  test();
#if TEST_STD_VER >= 2023
  static_assert(test());
#endif // TEST_STD_VER >= 2023

  return 0;
}
