/* This file is generated from virtual.ops.  Do not edit directly. */

void emulate_arith3(int code, struct reg_type *dest, struct reg_type *src1, struct reg_type *src2)
{
    switch(code) {
	  case dill_jmp_addi:  dest->u.i.i =  src1->u.i.i +  src2->u.i.i; break;
	  case dill_jmp_addu:  dest->u.u.u =  src1->u.u.u +  src2->u.u.u; break;
	  case dill_jmp_addul:  dest->u.ul.ul =  src1->u.ul.ul +  src2->u.ul.ul; break;
	  case dill_jmp_addl:  dest->u.l.l =  src1->u.l.l +  src2->u.l.l; break;
	  case dill_jmp_addp:  dest->u.p.p = (char*) src1->u.p.p + (IMM_TYPE) src2->u.p.p; break;
	  case dill_jmp_subi:  dest->u.i.i =  src1->u.i.i -  src2->u.i.i; break;
	  case dill_jmp_subu:  dest->u.u.u =  src1->u.u.u -  src2->u.u.u; break;
	  case dill_jmp_subul:  dest->u.ul.ul =  src1->u.ul.ul -  src2->u.ul.ul; break;
	  case dill_jmp_subl:  dest->u.l.l =  src1->u.l.l -  src2->u.l.l; break;
	  case dill_jmp_subp:  dest->u.p.p = (char*) src1->u.p.p - (IMM_TYPE) src2->u.p.p; break;
	  case dill_jmp_mulu:  dest->u.u.u =  src1->u.u.u *  src2->u.u.u; break;
	  case dill_jmp_mulul:  dest->u.ul.ul =  src1->u.ul.ul *  src2->u.ul.ul; break;
	  case dill_jmp_muli:  dest->u.i.i =  src1->u.i.i *  src2->u.i.i; break;
	  case dill_jmp_mull:  dest->u.l.l =  src1->u.l.l *  src2->u.l.l; break;
	  case dill_jmp_divu:  dest->u.u.u =  src1->u.u.u /  src2->u.u.u; break;
	  case dill_jmp_divul:  dest->u.ul.ul =  src1->u.ul.ul /  src2->u.ul.ul; break;
	  case dill_jmp_divi:  dest->u.i.i =  src1->u.i.i /  src2->u.i.i; break;
	  case dill_jmp_divl:  dest->u.l.l =  src1->u.l.l /  src2->u.l.l; break;
	  case dill_jmp_modu:  dest->u.u.u =  src1->u.u.u %  src2->u.u.u; break;
	  case dill_jmp_modul:  dest->u.ul.ul =  src1->u.ul.ul %  src2->u.ul.ul; break;
	  case dill_jmp_modi:  dest->u.i.i =  src1->u.i.i %  src2->u.i.i; break;
	  case dill_jmp_modl:  dest->u.l.l =  src1->u.l.l %  src2->u.l.l; break;
	  case dill_jmp_andu:  dest->u.u.u =  src1->u.u.u &  src2->u.u.u; break;
	  case dill_jmp_andul:  dest->u.ul.ul =  src1->u.ul.ul &  src2->u.ul.ul; break;
	  case dill_jmp_andi:  dest->u.i.i =  src1->u.i.i &  src2->u.i.i; break;
	  case dill_jmp_andl:  dest->u.l.l =  src1->u.l.l &  src2->u.l.l; break;
	  case dill_jmp_oru:  dest->u.u.u =  src1->u.u.u |  src2->u.u.u; break;
	  case dill_jmp_orul:  dest->u.ul.ul =  src1->u.ul.ul |  src2->u.ul.ul; break;
	  case dill_jmp_ori:  dest->u.i.i =  src1->u.i.i |  src2->u.i.i; break;
	  case dill_jmp_orl:  dest->u.l.l =  src1->u.l.l |  src2->u.l.l; break;
	  case dill_jmp_xoru:  dest->u.u.u =  src1->u.u.u ^  src2->u.u.u; break;
	  case dill_jmp_xorul:  dest->u.ul.ul =  src1->u.ul.ul ^  src2->u.ul.ul; break;
	  case dill_jmp_xori:  dest->u.i.i =  src1->u.i.i ^  src2->u.i.i; break;
	  case dill_jmp_xorl:  dest->u.l.l =  src1->u.l.l ^  src2->u.l.l; break;
	  case dill_jmp_lshu:  dest->u.u.u =  src1->u.u.u <<  src2->u.u.u; break;
	  case dill_jmp_lshul:  dest->u.ul.ul =  src1->u.ul.ul <<  src2->u.ul.ul; break;
	  case dill_jmp_lshi:  dest->u.i.i =  src1->u.i.i <<  src2->u.i.i; break;
	  case dill_jmp_lshl:  dest->u.l.l =  src1->u.l.l <<  src2->u.l.l; break;
	  case dill_jmp_rshu:  dest->u.u.u =  src1->u.u.u >>  src2->u.u.u; break;
	  case dill_jmp_rshul:  dest->u.ul.ul =  src1->u.ul.ul >>  src2->u.ul.ul; break;
	  case dill_jmp_rshi:  dest->u.i.i =  src1->u.i.i >>  src2->u.i.i; break;
	  case dill_jmp_rshl:  dest->u.l.l =  src1->u.l.l >>  src2->u.l.l; break;
	  case dill_jmp_addf:  dest->u.f.f =  src1->u.f.f +  src2->u.f.f; break;
	  case dill_jmp_addd:  dest->u.d.d =  src1->u.d.d +  src2->u.d.d; break;
	  case dill_jmp_subf:  dest->u.f.f =  src1->u.f.f -  src2->u.f.f; break;
	  case dill_jmp_subd:  dest->u.d.d =  src1->u.d.d -  src2->u.d.d; break;
	  case dill_jmp_mulf:  dest->u.f.f =  src1->u.f.f *  src2->u.f.f; break;
	  case dill_jmp_muld:  dest->u.d.d =  src1->u.d.d *  src2->u.d.d; break;
	  case dill_jmp_divf:  dest->u.f.f =  src1->u.f.f /  src2->u.f.f; break;
	  case dill_jmp_divd:  dest->u.d.d =  src1->u.d.d /  src2->u.d.d; break;
    }
}
void emulate_arith3i(int code, struct reg_type *dest, struct reg_type *src1, IMM_TYPE imm)
{
    switch(code) {
	  case dill_jmp_addi:  dest->u.i.i =  src1->u.i.i + (int) imm; break;
	  case dill_jmp_addu:  dest->u.u.u =  src1->u.u.u + (unsigned int) imm; break;
	  case dill_jmp_addul:  dest->u.ul.ul =  src1->u.ul.ul +  imm; break;
	  case dill_jmp_addl:  dest->u.l.l =  src1->u.l.l +  imm; break;
	  case dill_jmp_addp:  dest->u.p.p = (char*) src1->u.p.p +  imm; break;
	  case dill_jmp_subi:  dest->u.i.i =  src1->u.i.i - (int) imm; break;
	  case dill_jmp_subu:  dest->u.u.u =  src1->u.u.u - (unsigned int) imm; break;
	  case dill_jmp_subul:  dest->u.ul.ul =  src1->u.ul.ul -  imm; break;
	  case dill_jmp_subl:  dest->u.l.l =  src1->u.l.l -  imm; break;
	  case dill_jmp_subp:  dest->u.p.p = (char*) src1->u.p.p -  imm; break;
	  case dill_jmp_mulu:  dest->u.u.u =  src1->u.u.u * (unsigned int) imm; break;
	  case dill_jmp_mulul:  dest->u.ul.ul =  src1->u.ul.ul *  imm; break;
	  case dill_jmp_muli:  dest->u.i.i =  src1->u.i.i * (int) imm; break;
	  case dill_jmp_mull:  dest->u.l.l =  src1->u.l.l *  imm; break;
	  case dill_jmp_divu:  dest->u.u.u =  src1->u.u.u / (unsigned int) imm; break;
	  case dill_jmp_divul:  dest->u.ul.ul =  src1->u.ul.ul /  imm; break;
	  case dill_jmp_divi:  dest->u.i.i =  src1->u.i.i / (int) imm; break;
	  case dill_jmp_divl:  dest->u.l.l =  src1->u.l.l /  imm; break;
	  case dill_jmp_modu:  dest->u.u.u =  src1->u.u.u % (unsigned int) imm; break;
	  case dill_jmp_modul:  dest->u.ul.ul =  src1->u.ul.ul %  imm; break;
	  case dill_jmp_modi:  dest->u.i.i =  src1->u.i.i % (int) imm; break;
	  case dill_jmp_modl:  dest->u.l.l =  src1->u.l.l %  imm; break;
	  case dill_jmp_andi:  dest->u.i.i =  src1->u.i.i & (int) imm; break;
	  case dill_jmp_andu:  dest->u.u.u =  src1->u.u.u & (unsigned int) imm; break;
	  case dill_jmp_andul:  dest->u.ul.ul =  src1->u.ul.ul &  imm; break;
	  case dill_jmp_andl:  dest->u.l.l =  src1->u.l.l &  imm; break;
	  case dill_jmp_ori:  dest->u.i.i =  src1->u.i.i | (int) imm; break;
	  case dill_jmp_oru:  dest->u.u.u =  src1->u.u.u | (unsigned int) imm; break;
	  case dill_jmp_orul:  dest->u.ul.ul =  src1->u.ul.ul |  imm; break;
	  case dill_jmp_orl:  dest->u.l.l =  src1->u.l.l |  imm; break;
	  case dill_jmp_xori:  dest->u.i.i =  src1->u.i.i ^ (int) imm; break;
	  case dill_jmp_xoru:  dest->u.u.u =  src1->u.u.u ^ (unsigned int) imm; break;
	  case dill_jmp_xorul:  dest->u.ul.ul =  src1->u.ul.ul ^  imm; break;
	  case dill_jmp_xorl:  dest->u.l.l =  src1->u.l.l ^  imm; break;
	  case dill_jmp_lshi:  dest->u.i.i =  src1->u.i.i << (int) imm; break;
	  case dill_jmp_lshu:  dest->u.u.u =  src1->u.u.u << (unsigned int) imm; break;
	  case dill_jmp_lshul:  dest->u.ul.ul =  src1->u.ul.ul <<  imm; break;
	  case dill_jmp_lshl:  dest->u.l.l =  src1->u.l.l <<  imm; break;
	  case dill_jmp_rshi:  dest->u.i.i =  src1->u.i.i >> (int) imm; break;
	  case dill_jmp_rshu:  dest->u.u.u =  src1->u.u.u >> (unsigned int) imm; break;
	  case dill_jmp_rshul:  dest->u.ul.ul =  src1->u.ul.ul >>  imm; break;
	  case dill_jmp_rshl:  dest->u.l.l =  src1->u.l.l >>  imm; break;
    }
}
void emulate_arith2(int code, struct reg_type *dest, struct reg_type *src)
{
    switch(code) {
	  case dill_jmp_comi:  dest->u.i.i = ~  src->u.i.i; break;
	  case dill_jmp_comu:  dest->u.u.u = ~  src->u.u.u; break;
	  case dill_jmp_comul:  dest->u.ul.ul = ~  src->u.ul.ul; break;
	  case dill_jmp_coml:  dest->u.l.l = ~  src->u.l.l; break;
	  case dill_jmp_noti:  dest->u.i.i = !  src->u.i.i; break;
	  case dill_jmp_notu:  dest->u.u.u = !  src->u.u.u; break;
	  case dill_jmp_notul:  dest->u.ul.ul = !  src->u.ul.ul; break;
	  case dill_jmp_notl:  dest->u.l.l = !  src->u.l.l; break;
	  case dill_jmp_negi:  dest->u.i.i = -  src->u.i.i; break;
	  case dill_jmp_negu:  dest->u.u.u = (unsigned) - (int)  src->u.u.u; break;
	  case dill_jmp_negul:  dest->u.ul.ul = (uintptr_t) - (intptr_t)  src->u.ul.ul; break;
	  case dill_jmp_negl:  dest->u.l.l = -  src->u.l.l; break;
	  case dill_jmp_negf:  dest->u.f.f = -  src->u.f.f; break;
	  case dill_jmp_negd:  dest->u.d.d = -  src->u.d.d; break;
	  case dill_jmp_bswaps:  dest->u.s.s =   src->u.s.s; break;
	  case dill_jmp_bswapus:  dest->u.us.us =   src->u.us.us; break;
	  case dill_jmp_bswapi:  dest->u.i.i =   src->u.i.i; break;
	  case dill_jmp_bswapu:  dest->u.u.u =   src->u.u.u; break;
	  case dill_jmp_bswapul:  dest->u.ul.ul =   src->u.ul.ul; break;
	  case dill_jmp_bswapl:  dest->u.l.l =   src->u.l.l; break;
	  case dill_jmp_bswapf:  dest->u.f.f =   src->u.f.f; break;
	  case dill_jmp_bswapd:  dest->u.d.d =   src->u.d.d; break;
    }
}
int emulate_branch(int code, struct reg_type *src1, struct reg_type *src2)
{
    switch(code) {
	  case dill_jmp_beqc:  return ( src1->u.c.c) == ( src2->u.c.c);
	  case dill_jmp_bequc:  return ( src1->u.uc.uc) == ( src2->u.uc.uc);
	  case dill_jmp_beqs:  return ( src1->u.s.s) == ( src2->u.s.s);
	  case dill_jmp_bequs:  return ( src1->u.us.us) == ( src2->u.us.us);
	  case dill_jmp_beqi:  return ( src1->u.i.i) == ( src2->u.i.i);
	  case dill_jmp_bequ:  return ( src1->u.u.u) == ( src2->u.u.u);
	  case dill_jmp_bequl:  return ( src1->u.ul.ul) == ( src2->u.ul.ul);
	  case dill_jmp_beql:  return ( src1->u.l.l) == ( src2->u.l.l);
	  case dill_jmp_beqp:  return ((char*) src1->u.p.p) == ((char*) src2->u.p.p);
	  case dill_jmp_beqd:  return ( src1->u.d.d) == ( src2->u.d.d);
	  case dill_jmp_beqf:  return ( src1->u.f.f) == ( src2->u.f.f);
	  case dill_jmp_bgec:  return ( src1->u.c.c) >= ( src2->u.c.c);
	  case dill_jmp_bgeuc:  return ( src1->u.uc.uc) >= ( src2->u.uc.uc);
	  case dill_jmp_bges:  return ( src1->u.s.s) >= ( src2->u.s.s);
	  case dill_jmp_bgeus:  return ( src1->u.us.us) >= ( src2->u.us.us);
	  case dill_jmp_bgei:  return ( src1->u.i.i) >= ( src2->u.i.i);
	  case dill_jmp_bgeu:  return ( src1->u.u.u) >= ( src2->u.u.u);
	  case dill_jmp_bgeul:  return ( src1->u.ul.ul) >= ( src2->u.ul.ul);
	  case dill_jmp_bgel:  return ( src1->u.l.l) >= ( src2->u.l.l);
	  case dill_jmp_bgep:  return ((char*) src1->u.p.p) >= ((char*) src2->u.p.p);
	  case dill_jmp_bged:  return ( src1->u.d.d) >= ( src2->u.d.d);
	  case dill_jmp_bgef:  return ( src1->u.f.f) >= ( src2->u.f.f);
	  case dill_jmp_bgtc:  return ( src1->u.c.c) > ( src2->u.c.c);
	  case dill_jmp_bgtuc:  return ( src1->u.uc.uc) > ( src2->u.uc.uc);
	  case dill_jmp_bgts:  return ( src1->u.s.s) > ( src2->u.s.s);
	  case dill_jmp_bgtus:  return ( src1->u.us.us) > ( src2->u.us.us);
	  case dill_jmp_bgti:  return ( src1->u.i.i) > ( src2->u.i.i);
	  case dill_jmp_bgtu:  return ( src1->u.u.u) > ( src2->u.u.u);
	  case dill_jmp_bgtul:  return ( src1->u.ul.ul) > ( src2->u.ul.ul);
	  case dill_jmp_bgtl:  return ( src1->u.l.l) > ( src2->u.l.l);
	  case dill_jmp_bgtp:  return ((char*) src1->u.p.p) > ((char*) src2->u.p.p);
	  case dill_jmp_bgtd:  return ( src1->u.d.d) > ( src2->u.d.d);
	  case dill_jmp_bgtf:  return ( src1->u.f.f) > ( src2->u.f.f);
	  case dill_jmp_blec:  return ( src1->u.c.c) <= ( src2->u.c.c);
	  case dill_jmp_bleuc:  return ( src1->u.uc.uc) <= ( src2->u.uc.uc);
	  case dill_jmp_bles:  return ( src1->u.s.s) <= ( src2->u.s.s);
	  case dill_jmp_bleus:  return ( src1->u.us.us) <= ( src2->u.us.us);
	  case dill_jmp_blei:  return ( src1->u.i.i) <= ( src2->u.i.i);
	  case dill_jmp_bleu:  return ( src1->u.u.u) <= ( src2->u.u.u);
	  case dill_jmp_bleul:  return ( src1->u.ul.ul) <= ( src2->u.ul.ul);
	  case dill_jmp_blel:  return ( src1->u.l.l) <= ( src2->u.l.l);
	  case dill_jmp_blep:  return ((char*) src1->u.p.p) <= ((char*) src2->u.p.p);
	  case dill_jmp_bled:  return ( src1->u.d.d) <= ( src2->u.d.d);
	  case dill_jmp_blef:  return ( src1->u.f.f) <= ( src2->u.f.f);
	  case dill_jmp_bltc:  return ( src1->u.c.c) < ( src2->u.c.c);
	  case dill_jmp_bltuc:  return ( src1->u.uc.uc) < ( src2->u.uc.uc);
	  case dill_jmp_blts:  return ( src1->u.s.s) < ( src2->u.s.s);
	  case dill_jmp_bltus:  return ( src1->u.us.us) < ( src2->u.us.us);
	  case dill_jmp_blti:  return ( src1->u.i.i) < ( src2->u.i.i);
	  case dill_jmp_bltu:  return ( src1->u.u.u) < ( src2->u.u.u);
	  case dill_jmp_bltul:  return ( src1->u.ul.ul) < ( src2->u.ul.ul);
	  case dill_jmp_bltl:  return ( src1->u.l.l) < ( src2->u.l.l);
	  case dill_jmp_bltp:  return ((char*) src1->u.p.p) < ((char*) src2->u.p.p);
	  case dill_jmp_bltd:  return ( src1->u.d.d) < ( src2->u.d.d);
	  case dill_jmp_bltf:  return ( src1->u.f.f) < ( src2->u.f.f);
	  case dill_jmp_bnec:  return ( src1->u.c.c) != ( src2->u.c.c);
	  case dill_jmp_bneuc:  return ( src1->u.uc.uc) != ( src2->u.uc.uc);
	  case dill_jmp_bnes:  return ( src1->u.s.s) != ( src2->u.s.s);
	  case dill_jmp_bneus:  return ( src1->u.us.us) != ( src2->u.us.us);
	  case dill_jmp_bnei:  return ( src1->u.i.i) != ( src2->u.i.i);
	  case dill_jmp_bneu:  return ( src1->u.u.u) != ( src2->u.u.u);
	  case dill_jmp_bneul:  return ( src1->u.ul.ul) != ( src2->u.ul.ul);
	  case dill_jmp_bnel:  return ( src1->u.l.l) != ( src2->u.l.l);
	  case dill_jmp_bnep:  return ((char*) src1->u.p.p) != ((char*) src2->u.p.p);
	  case dill_jmp_bned:  return ( src1->u.d.d) != ( src2->u.d.d);
	  case dill_jmp_bnef:  return ( src1->u.f.f) != ( src2->u.f.f);
    }return 0;
}
int emulate_compare(int code, struct reg_type *src1, struct reg_type *src2)
{
    switch(code) {
	  case dill_jmp_ceqc:  return ( src1->u.c.c) == ( src2->u.c.c);
	  case dill_jmp_cequc:  return ( src1->u.uc.uc) == ( src2->u.uc.uc);
	  case dill_jmp_ceqs:  return ( src1->u.s.s) == ( src2->u.s.s);
	  case dill_jmp_cequs:  return ( src1->u.us.us) == ( src2->u.us.us);
	  case dill_jmp_ceqi:  return ( src1->u.i.i) == ( src2->u.i.i);
	  case dill_jmp_cequ:  return ( src1->u.u.u) == ( src2->u.u.u);
	  case dill_jmp_cequl:  return ( src1->u.ul.ul) == ( src2->u.ul.ul);
	  case dill_jmp_ceql:  return ( src1->u.l.l) == ( src2->u.l.l);
	  case dill_jmp_ceqp:  return ((char*) src1->u.p.p) == ((char*) src2->u.p.p);
	  case dill_jmp_ceqd:  return ( src1->u.d.d) == ( src2->u.d.d);
	  case dill_jmp_ceqf:  return ( src1->u.f.f) == ( src2->u.f.f);
	  case dill_jmp_cgec:  return ( src1->u.c.c) >= ( src2->u.c.c);
	  case dill_jmp_cgeuc:  return ( src1->u.uc.uc) >= ( src2->u.uc.uc);
	  case dill_jmp_cges:  return ( src1->u.s.s) >= ( src2->u.s.s);
	  case dill_jmp_cgeus:  return ( src1->u.us.us) >= ( src2->u.us.us);
	  case dill_jmp_cgei:  return ( src1->u.i.i) >= ( src2->u.i.i);
	  case dill_jmp_cgeu:  return ( src1->u.u.u) >= ( src2->u.u.u);
	  case dill_jmp_cgeul:  return ( src1->u.ul.ul) >= ( src2->u.ul.ul);
	  case dill_jmp_cgel:  return ( src1->u.l.l) >= ( src2->u.l.l);
	  case dill_jmp_cgep:  return ((char*) src1->u.p.p) >= ((char*) src2->u.p.p);
	  case dill_jmp_cged:  return ( src1->u.d.d) >= ( src2->u.d.d);
	  case dill_jmp_cgef:  return ( src1->u.f.f) >= ( src2->u.f.f);
	  case dill_jmp_cgtc:  return ( src1->u.c.c) > ( src2->u.c.c);
	  case dill_jmp_cgtuc:  return ( src1->u.uc.uc) > ( src2->u.uc.uc);
	  case dill_jmp_cgts:  return ( src1->u.s.s) > ( src2->u.s.s);
	  case dill_jmp_cgtus:  return ( src1->u.us.us) > ( src2->u.us.us);
	  case dill_jmp_cgti:  return ( src1->u.i.i) > ( src2->u.i.i);
	  case dill_jmp_cgtu:  return ( src1->u.u.u) > ( src2->u.u.u);
	  case dill_jmp_cgtul:  return ( src1->u.ul.ul) > ( src2->u.ul.ul);
	  case dill_jmp_cgtl:  return ( src1->u.l.l) > ( src2->u.l.l);
	  case dill_jmp_cgtp:  return ((char*) src1->u.p.p) > ((char*) src2->u.p.p);
	  case dill_jmp_cgtd:  return ( src1->u.d.d) > ( src2->u.d.d);
	  case dill_jmp_cgtf:  return ( src1->u.f.f) > ( src2->u.f.f);
	  case dill_jmp_clec:  return ( src1->u.c.c) <= ( src2->u.c.c);
	  case dill_jmp_cleuc:  return ( src1->u.uc.uc) <= ( src2->u.uc.uc);
	  case dill_jmp_cles:  return ( src1->u.s.s) <= ( src2->u.s.s);
	  case dill_jmp_cleus:  return ( src1->u.us.us) <= ( src2->u.us.us);
	  case dill_jmp_clei:  return ( src1->u.i.i) <= ( src2->u.i.i);
	  case dill_jmp_cleu:  return ( src1->u.u.u) <= ( src2->u.u.u);
	  case dill_jmp_cleul:  return ( src1->u.ul.ul) <= ( src2->u.ul.ul);
	  case dill_jmp_clel:  return ( src1->u.l.l) <= ( src2->u.l.l);
	  case dill_jmp_clep:  return ((char*) src1->u.p.p) <= ((char*) src2->u.p.p);
	  case dill_jmp_cled:  return ( src1->u.d.d) <= ( src2->u.d.d);
	  case dill_jmp_clef:  return ( src1->u.f.f) <= ( src2->u.f.f);
	  case dill_jmp_cltc:  return ( src1->u.c.c) < ( src2->u.c.c);
	  case dill_jmp_cltuc:  return ( src1->u.uc.uc) < ( src2->u.uc.uc);
	  case dill_jmp_clts:  return ( src1->u.s.s) < ( src2->u.s.s);
	  case dill_jmp_cltus:  return ( src1->u.us.us) < ( src2->u.us.us);
	  case dill_jmp_clti:  return ( src1->u.i.i) < ( src2->u.i.i);
	  case dill_jmp_cltu:  return ( src1->u.u.u) < ( src2->u.u.u);
	  case dill_jmp_cltul:  return ( src1->u.ul.ul) < ( src2->u.ul.ul);
	  case dill_jmp_cltl:  return ( src1->u.l.l) < ( src2->u.l.l);
	  case dill_jmp_cltp:  return ((char*) src1->u.p.p) < ((char*) src2->u.p.p);
	  case dill_jmp_cltd:  return ( src1->u.d.d) < ( src2->u.d.d);
	  case dill_jmp_cltf:  return ( src1->u.f.f) < ( src2->u.f.f);
	  case dill_jmp_cnec:  return ( src1->u.c.c) != ( src2->u.c.c);
	  case dill_jmp_cneuc:  return ( src1->u.uc.uc) != ( src2->u.uc.uc);
	  case dill_jmp_cnes:  return ( src1->u.s.s) != ( src2->u.s.s);
	  case dill_jmp_cneus:  return ( src1->u.us.us) != ( src2->u.us.us);
	  case dill_jmp_cnei:  return ( src1->u.i.i) != ( src2->u.i.i);
	  case dill_jmp_cneu:  return ( src1->u.u.u) != ( src2->u.u.u);
	  case dill_jmp_cneul:  return ( src1->u.ul.ul) != ( src2->u.ul.ul);
	  case dill_jmp_cnel:  return ( src1->u.l.l) != ( src2->u.l.l);
	  case dill_jmp_cnep:  return ((char*) src1->u.p.p) != ((char*) src2->u.p.p);
	  case dill_jmp_cned:  return ( src1->u.d.d) != ( src2->u.d.d);
	  case dill_jmp_cnef:  return ( src1->u.f.f) != ( src2->u.f.f);
    }return 0;
}
int emulate_branchi(int code, struct reg_type *src1, IMM_TYPE imm)
{
    switch(code) {
	  case dill_jmp_beqc:  return ( src1->u.c.c) ==  imm;
	  case dill_jmp_bequc:  return ( src1->u.uc.uc) ==  imm;
	  case dill_jmp_beqs:  return ( src1->u.s.s) ==  imm;
	  case dill_jmp_bequs:  return ( src1->u.us.us) ==  imm;
	  case dill_jmp_beqi:  return ( src1->u.i.i) ==  imm;
	  case dill_jmp_bequ:  return ((unsigned int) src1->u.u.u) == (unsigned int) imm;
	  case dill_jmp_bequl:  return ((uintptr_t) src1->u.ul.ul) == (uintptr_t) imm;
	  case dill_jmp_beql:  return ( src1->u.l.l) ==  imm;
	  case dill_jmp_beqp:  return ((IMM_TYPE) src1->u.p.p) == (IMM_TYPE) imm;
	  case dill_jmp_bgec:  return ( src1->u.c.c) >=  imm;
	  case dill_jmp_bgeuc:  return ( src1->u.uc.uc) >=  imm;
	  case dill_jmp_bges:  return ( src1->u.s.s) >=  imm;
	  case dill_jmp_bgeus:  return ( src1->u.us.us) >=  imm;
	  case dill_jmp_bgei:  return ( src1->u.i.i) >=  imm;
	  case dill_jmp_bgeu:  return ((unsigned int) src1->u.u.u) >= (unsigned int) imm;
	  case dill_jmp_bgeul:  return ((uintptr_t) src1->u.ul.ul) >= (uintptr_t) imm;
	  case dill_jmp_bgel:  return ( src1->u.l.l) >=  imm;
	  case dill_jmp_bgep:  return ((IMM_TYPE) src1->u.p.p) >= (IMM_TYPE) imm;
	  case dill_jmp_bgtc:  return ( src1->u.c.c) >  imm;
	  case dill_jmp_bgtuc:  return ( src1->u.uc.uc) >  imm;
	  case dill_jmp_bgts:  return ( src1->u.s.s) >  imm;
	  case dill_jmp_bgtus:  return ( src1->u.us.us) >  imm;
	  case dill_jmp_bgti:  return ( src1->u.i.i) >  imm;
	  case dill_jmp_bgtu:  return ((unsigned int) src1->u.u.u) > (unsigned int) imm;
	  case dill_jmp_bgtul:  return ((uintptr_t) src1->u.ul.ul) > (uintptr_t) imm;
	  case dill_jmp_bgtl:  return ( src1->u.l.l) >  imm;
	  case dill_jmp_bgtp:  return ((IMM_TYPE) src1->u.p.p) > (IMM_TYPE) imm;
	  case dill_jmp_blec:  return ( src1->u.c.c) <=  imm;
	  case dill_jmp_bleuc:  return ( src1->u.uc.uc) <=  imm;
	  case dill_jmp_bles:  return ( src1->u.s.s) <=  imm;
	  case dill_jmp_bleus:  return ( src1->u.us.us) <=  imm;
	  case dill_jmp_blei:  return ( src1->u.i.i) <=  imm;
	  case dill_jmp_bleu:  return ((unsigned int) src1->u.u.u) <= (unsigned int) imm;
	  case dill_jmp_bleul:  return ((uintptr_t) src1->u.ul.ul) <= (uintptr_t) imm;
	  case dill_jmp_blel:  return ( src1->u.l.l) <=  imm;
	  case dill_jmp_blep:  return ((IMM_TYPE) src1->u.p.p) <= (IMM_TYPE) imm;
	  case dill_jmp_bltc:  return ( src1->u.c.c) <  imm;
	  case dill_jmp_bltuc:  return ( src1->u.uc.uc) <  imm;
	  case dill_jmp_blts:  return ( src1->u.s.s) <  imm;
	  case dill_jmp_bltus:  return ( src1->u.us.us) <  imm;
	  case dill_jmp_blti:  return ( src1->u.i.i) <  imm;
	  case dill_jmp_bltu:  return ((unsigned int) src1->u.u.u) < (unsigned int) imm;
	  case dill_jmp_bltul:  return ((uintptr_t) src1->u.ul.ul) < (uintptr_t) imm;
	  case dill_jmp_bltl:  return ( src1->u.l.l) <  imm;
	  case dill_jmp_bltp:  return ((IMM_TYPE) src1->u.p.p) < (IMM_TYPE) imm;
	  case dill_jmp_bnec:  return ( src1->u.c.c) !=  imm;
	  case dill_jmp_bneuc:  return ( src1->u.uc.uc) !=  imm;
	  case dill_jmp_bnes:  return ( src1->u.s.s) !=  imm;
	  case dill_jmp_bneus:  return ( src1->u.us.us) !=  imm;
	  case dill_jmp_bnei:  return ( src1->u.i.i) !=  imm;
	  case dill_jmp_bneu:  return ((unsigned int) src1->u.u.u) != (unsigned int) imm;
	  case dill_jmp_bneul:  return ((uintptr_t) src1->u.ul.ul) != (uintptr_t) imm;
	  case dill_jmp_bnel:  return ( src1->u.l.l) !=  imm;
	  case dill_jmp_bnep:  return ((IMM_TYPE) src1->u.p.p) != (IMM_TYPE) imm;
    }return 0;
}
#define CONV(x,y) ((x<<4)+y)
void emulate_convert(int code, struct reg_type *dest, struct reg_type *src)
{
    switch(code) {
	case CONV(DILL_C, DILL_UC): dest->u.uc.uc = (unsigned char) src->u.c.c; break;
	case CONV(DILL_C, DILL_S): dest->u.s.s = (short) src->u.c.c; break;
	case CONV(DILL_C, DILL_US): dest->u.us.us = (unsigned short) src->u.c.c; break;
	case CONV(DILL_C, DILL_I): dest->u.i.i = (int) src->u.c.c; break;
	case CONV(DILL_C, DILL_U): dest->u.u.u = (unsigned int) src->u.c.c; break;
	case CONV(DILL_C, DILL_UL): dest->u.ul.ul = (uintptr_t) src->u.c.c; break;
	case CONV(DILL_C, DILL_L): dest->u.l.l = (intptr_t) src->u.c.c; break;
	case CONV(DILL_D, DILL_C): dest->u.c.c = (char) src->u.d.d; break;
	case CONV(DILL_D, DILL_UC): dest->u.uc.uc = (unsigned char) src->u.d.d; break;
	case CONV(DILL_D, DILL_S): dest->u.s.s = (short) src->u.d.d; break;
	case CONV(DILL_D, DILL_US): dest->u.us.us = (unsigned short) src->u.d.d; break;
	case CONV(DILL_D, DILL_I): dest->u.i.i = (int) src->u.d.d; break;
	case CONV(DILL_D, DILL_U): dest->u.u.u = (unsigned int) src->u.d.d; break;
	case CONV(DILL_D, DILL_UL): dest->u.ul.ul = (uintptr_t) src->u.d.d; break;
	case CONV(DILL_D, DILL_L): dest->u.l.l = (intptr_t) src->u.d.d; break;
	case CONV(DILL_F, DILL_C): dest->u.c.c = (char) src->u.f.f; break;
	case CONV(DILL_F, DILL_UC): dest->u.uc.uc = (unsigned char) src->u.f.f; break;
	case CONV(DILL_F, DILL_S): dest->u.s.s = (short) src->u.f.f; break;
	case CONV(DILL_F, DILL_US): dest->u.us.us = (unsigned short) src->u.f.f; break;
	case CONV(DILL_F, DILL_I): dest->u.i.i = (int) src->u.f.f; break;
	case CONV(DILL_F, DILL_U): dest->u.u.u = (unsigned int) src->u.f.f; break;
	case CONV(DILL_F, DILL_UL): dest->u.ul.ul = (uintptr_t) src->u.f.f; break;
	case CONV(DILL_F, DILL_L): dest->u.l.l = (intptr_t) src->u.f.f; break;
	case CONV(DILL_I, DILL_C): dest->u.c.c = (char) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_UC): dest->u.uc.uc = (unsigned char) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_S): dest->u.s.s = (short) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_US): dest->u.us.us = (unsigned short) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_U): dest->u.u.u = (unsigned int) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_UL): dest->u.ul.ul = (uintptr_t) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_L): dest->u.l.l = (intptr_t) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_L, DILL_C): dest->u.c.c = (char) src->u.l.l; break;
	case CONV(DILL_L, DILL_UC): dest->u.uc.uc = (unsigned char) src->u.l.l; break;
	case CONV(DILL_L, DILL_S): dest->u.s.s = (short) src->u.l.l; break;
	case CONV(DILL_L, DILL_US): dest->u.us.us = (unsigned short) src->u.l.l; break;
	case CONV(DILL_L, DILL_I): dest->u.i.i = (int) src->u.l.l; break;
	case CONV(DILL_L, DILL_U): dest->u.u.u = (unsigned int) src->u.l.l; break;
	case CONV(DILL_L, DILL_UL): dest->u.ul.ul = (uintptr_t) src->u.l.l; break;
	case CONV(DILL_S, DILL_C): dest->u.c.c = (char) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_UC): dest->u.uc.uc = (unsigned char) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_US): dest->u.us.us = (unsigned short) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_I): dest->u.i.i = (int) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_U): dest->u.u.u = (unsigned int) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_UL): dest->u.ul.ul = (uintptr_t) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_L): dest->u.l.l = (intptr_t) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_U, DILL_C): dest->u.c.c = (char) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_UC): dest->u.uc.uc = (unsigned char) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_S): dest->u.s.s = (short) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_US): dest->u.us.us = (unsigned short) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_I): dest->u.i.i = (int) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_UL): dest->u.ul.ul = (uintptr_t) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_L): dest->u.l.l = (intptr_t) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_UL, DILL_C): dest->u.c.c = (char) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_UC): dest->u.uc.uc = (unsigned char) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_S): dest->u.s.s = (short) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_US): dest->u.us.us = (unsigned short) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_I): dest->u.i.i = (int) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_U): dest->u.u.u = (unsigned int) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_L): dest->u.l.l = (intptr_t) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_US, DILL_C): dest->u.c.c = (char) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_UC): dest->u.uc.uc = (unsigned char) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_S): dest->u.s.s = (short) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_I): dest->u.i.i = (int) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_U): dest->u.u.u = (unsigned int) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_UL): dest->u.ul.ul = (uintptr_t) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_L): dest->u.l.l = (intptr_t) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_UC, DILL_C): dest->u.c.c = (char) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_S): dest->u.s.s = (short) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_US): dest->u.us.us = (unsigned short) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_I): dest->u.i.i = (int) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_U): dest->u.u.u = (unsigned int) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_UL): dest->u.ul.ul = (uintptr_t) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_L): dest->u.l.l = (intptr_t) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_C, DILL_F): dest->u.f.f = (float) src->u.c.c; break;
	case CONV(DILL_C, DILL_D): dest->u.d.d = (double) src->u.c.c; break;
	case CONV(DILL_UC, DILL_F): dest->u.f.f = (float) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_UC, DILL_D): dest->u.d.d = (double) ((unsigned char)(0xff & src->u.uc.uc)); break;
	case CONV(DILL_S, DILL_F): dest->u.f.f = (float) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_S, DILL_D): dest->u.d.d = (double) ((short)(0xffff & src->u.s.s)); break;
	case CONV(DILL_US, DILL_F): dest->u.f.f = (float) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_US, DILL_D): dest->u.d.d = (double) ((unsigned short)(0xffff & src->u.us.us)); break;
	case CONV(DILL_D, DILL_F): dest->u.f.f = (float) src->u.d.d; break;
	case CONV(DILL_F, DILL_D): dest->u.d.d = (double) src->u.f.f; break;
	case CONV(DILL_I, DILL_F): dest->u.f.f = (float) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_I, DILL_D): dest->u.d.d = (double) ((int)(0xffffffff & src->u.i.i)); break;
	case CONV(DILL_L, DILL_F): dest->u.f.f = (float) src->u.l.l; break;
	case CONV(DILL_L, DILL_D): dest->u.d.d = (double) src->u.l.l; break;
	case CONV(DILL_U, DILL_F): dest->u.f.f = (float) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_U, DILL_D): dest->u.d.d = (double) ((unsigned int)(0xffffffff & src->u.u.u)); break;
	case CONV(DILL_UL, DILL_F): dest->u.f.f = (float) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_UL, DILL_D): dest->u.d.d = (double) (UIMM_TYPE)src->u.ul.ul; break;
	case CONV(DILL_P, DILL_UL): dest->u.ul.ul = (uintptr_t) src->u.l.l; break;
	case CONV(DILL_UL, DILL_P): dest->u.ul.ul =  (UIMM_TYPE)src->u.ul.ul; break;
        default: printf("convert missed case %x \n", code); break;}
}
int emulate_loadi(int code, struct reg_type *dest, struct reg_type *src, IMM_TYPE imm)
{
    switch(code) {
	case DILL_C: dest->u.l.l = (IMM_TYPE) *((char*)(src->u.l.l + imm)); break;
	case DILL_D: dest->u.d.d = *((double*)(src->u.l.l + imm)); break;
	case DILL_F: dest->u.f.f = *((float*)(src->u.l.l + imm)); break;
	case DILL_I: dest->u.l.l = (IMM_TYPE) *((int*)(src->u.l.l + imm)); break;
	case DILL_L: dest->u.l.l = (IMM_TYPE) *((IMM_TYPE*)(src->u.l.l + imm)); break;
	case DILL_S: dest->u.l.l = (IMM_TYPE) *((short*)(src->u.l.l + imm)); break;
	case DILL_U: dest->u.l.l = (IMM_TYPE) *((unsigned int *)(src->u.l.l + imm)); break;
	case DILL_UL: dest->u.l.l = (IMM_TYPE) *((UIMM_TYPE *)(src->u.l.l + imm)); break;
	case DILL_US: dest->u.l.l = (IMM_TYPE) *((unsigned short *)(src->u.l.l + imm)); break;
	case DILL_UC: dest->u.l.l = (IMM_TYPE) *((unsigned char*)(src->u.l.l + imm)); break;
	case DILL_P: dest->u.l.l = (IMM_TYPE) *((void**)((char*)src->u.p.p + imm)); break;
    default: printf("loadi missed case %x \n", code); break;}return 0;
}
int emulate_storei(int code, struct reg_type *dest, struct reg_type *src, IMM_TYPE imm)
{
    switch(code) {
	case DILL_C: *((char*)(src->u.l.l + imm)) = dest->u.c.c; break;
	case DILL_D: *((double*)(src->u.l.l + imm)) = dest->u.d.d; break;
	case DILL_F: *((float*)(src->u.l.l + imm)) = dest->u.f.f; break;
	case DILL_I: *((int*)(src->u.l.l + imm)) = dest->u.i.i; break;
	case DILL_L: *((IMM_TYPE*)(src->u.l.l + imm)) = dest->u.l.l; break;
	case DILL_S: *((short*)(src->u.l.l + imm)) = dest->u.s.s; break;
	case DILL_U: *((unsigned int *)(src->u.l.l + imm)) = dest->u.u.u; break;
	case DILL_UL: *((UIMM_TYPE *)(src->u.l.l + imm)) = dest->u.ul.ul; break;
	case DILL_US: *((unsigned short *)(src->u.l.l + imm)) = dest->u.us.us; break;
	case DILL_UC: *((unsigned char*)(src->u.l.l + imm)) = dest->u.uc.uc; break;
	case DILL_P: *((void**)((char*)src->u.p.p + imm)) = dest->u.p.p; break;
    }return 0;
}
