#! /bin/sh

# This is a sample script for demonstrating how to handle unknown users in
# a more friendly way than just returning a "user unknown" error. It can
# be called from a pipe transport set up like this:

# unknownuser_pipe:
#   driver = pipe;
#   command = "/opt/exim/util/unknownuser.sh",
#   ignore_status,
#   return_output,
#   user = nobody

# which is specified by a smartuser director set up like this:

# unknownuser:
#   transport = unknownuser_pipe,
#   no_verify,
#   driver = smartuser;

# Any output generated by this script is then returned to the sender of
# the message. You can run any commands you like at this point, for example,
# to attempt fuzzy matches on the local part of the address. Here we just
# give a bland message, demonstrating the availability of the variables
# $LOCAL_PART and $DOMAIN.

cat <<End
"$LOCAL_PART" is not a known user mailbox in the domain "$DOMAIN".
End



